/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.algo.util.memory.DataInputView;
import kd.bos.algo.util.memory.DataOutputView;
import kd.bos.algo.util.types.TypeSerializer;

public class BigDecimalSerializer
extends TypeSerializer<BigDecimal> {
    public static final BigDecimalSerializer INSTANCE = new BigDecimalSerializer();

    @Override
    public void serialize(BigDecimal value, DataOutputView target) throws IOException {
        if (value == null) {
            BigDecimalSerializer.writeBigInteger(null, target);
            return;
        }
        if (value == BigDecimal.ZERO) {
            BigDecimalSerializer.writeBigInteger(BigInteger.ZERO, target);
            target.writeInt(0);
            return;
        }
        if (value == BigDecimal.ONE) {
            BigDecimalSerializer.writeBigInteger(BigInteger.ONE, target);
            target.writeInt(0);
            return;
        }
        if (value == BigDecimal.TEN) {
            BigDecimalSerializer.writeBigInteger(BigInteger.TEN, target);
            target.writeInt(0);
            return;
        }
        BigDecimal bd = value;
        BigDecimalSerializer.writeBigInteger(bd.unscaledValue(), target);
        target.writeInt(bd.scale());
    }

    @Override
    public BigDecimal deserialize(DataInputView source) throws IOException {
        BigInteger unscaledValue = BigDecimalSerializer.readBigInteger(source);
        if (unscaledValue == null) {
            return null;
        }
        int scale = source.readInt();
        if (scale == 0) {
            if (unscaledValue == BigInteger.ZERO) {
                return BigDecimal.ZERO;
            }
            if (unscaledValue == BigInteger.ONE) {
                return BigDecimal.ONE;
            }
            if (unscaledValue == BigInteger.TEN) {
                return BigDecimal.TEN;
            }
        }
        return new BigDecimal(unscaledValue, scale);
    }

    public static void writeBigInteger(BigInteger value, DataOutput target) throws IOException {
        if (value == null) {
            target.writeInt(0);
            return;
        }
        if (value == BigInteger.ZERO) {
            target.writeInt(1);
            return;
        }
        if (value == BigInteger.ONE) {
            target.writeInt(2);
            return;
        }
        if (value == BigInteger.TEN) {
            target.writeInt(3);
            return;
        }
        byte[] bytes = value.toByteArray();
        target.writeInt(bytes.length + 4);
        target.write(bytes);
    }

    public static BigInteger readBigInteger(DataInput source) throws IOException {
        int len = source.readInt();
        if (len < 4) {
            switch (len) {
                case 0: {
                    return null;
                }
                case 1: {
                    return BigInteger.ZERO;
                }
                case 2: {
                    return BigInteger.ONE;
                }
                case 3: {
                    return BigInteger.TEN;
                }
            }
        }
        byte[] bytes = new byte[len - 4];
        source.readFully(bytes);
        return new BigInteger(bytes);
    }
}

