/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class JobProgressListener {
    private static Log logger = LogFactory.getLog(JobProgressListener.class);
    private static List<JobProgressListener> impls = new ArrayList<JobProgressListener>();

    protected abstract void onStart(Object var1, String var2, String var3);

    protected abstract void onFinished(Object var1, String var2, String var3);

    protected abstract void onFailed(Object var1, String var2, String var3);

    @Deprecated
    public static void setImpl(JobProgressListener impl) {
        if (impl == null) {
            return;
        }
        impls.add(impl);
    }

    @Deprecated
    public static void setImpl(String className) {
        if (!className.isEmpty()) {
            try {
                JobProgressListener impl = (JobProgressListener)Class.forName(className).newInstance();
                impls.add(impl);
            }
            catch (Error | Exception t) {
                logger.error("init class " + className + " error:", t);
            }
        }
    }

    public static void addImpl(JobProgressListener impl) {
        if (impl == null) {
            return;
        }
        impls.add(impl);
    }

    public static void addImpl(String className) {
        if (!className.isEmpty()) {
            try {
                JobProgressListener impl = (JobProgressListener)Class.forName(className).newInstance();
                impls.add(impl);
            }
            catch (Error | Exception t) {
                logger.error("init class " + className + " error:", t);
            }
        }
    }

    public static void start(Object jobId, String title, String region) {
        for (JobProgressListener impl : impls) {
            try {
                impl.onStart(jobId, title, region);
            }
            catch (Error | Exception t) {
                logger.error("onStart error:", t);
            }
        }
    }

    public static void finished(Object jobId, String title, String region) {
        for (JobProgressListener impl : impls) {
            try {
                impl.onFinished(jobId, title, region);
            }
            catch (Error | Exception t) {
                logger.error("onFinished error:", t);
            }
        }
    }

    public static void failed(Object jobId, String title, String region) {
        for (JobProgressListener impl : impls) {
            try {
                impl.onFailed(jobId, title, region);
            }
            catch (Error | Exception t) {
                logger.error("onFinished error:", t);
            }
        }
    }
}

