/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox;

import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.AlgoXException;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.algox.core.DataSourceX;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.datachannel.DataChannels;
import kd.bos.algox.jobclient.JobClientFactory;
import kd.bos.algox.region.JobRegionMapping;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class JobSession {
    private JobContext context = new JobContext();

    @SdkInternal
    JobSession() {
    }

    @SdkInternal
    JobSession(String jobName) {
        this(jobName, null);
    }

    @SdkInternal
    JobSession(String jobName, String title) {
        this.context.setJobName(jobName);
        this.context.setTitle(title);
        this.handleClusterRegion(jobName, null);
    }

    @SdkInternal
    public void disableLocalModel() {
        this.context.disableLocalModel();
    }

    public DataSetX fromInput(Input input) {
        return new DataSourceX(this.context, input);
    }

    public DataSetX fromInput(Input ... inputs) {
        if (inputs.length == 0) {
            throw new AlgoXException("Inputs is empty.");
        }
        return new DataSourceX(this.context, inputs);
    }

    public void commit(int timeout, TimeUnit timeUnit) throws CommitTimeoutException, RunningTimeoutException {
        this.commit(timeout, timeout, timeUnit);
    }

    public void commit(int commitTimeout, int runningTimeout, TimeUnit timeUnit) throws CommitTimeoutException, RunningTimeoutException {
        JobClientFactory.get().commit(this.context, commitTimeout, runningTimeout, timeUnit);
    }

    public String asyncCommit(int timeout, TimeUnit timeUnit, AlgoXCallBack callback) {
        return this.asyncCommit(timeout, timeout, timeUnit, callback);
    }

    public String asyncCommit(int commitTimeout, int runningTimeout, TimeUnit timeUnit, AlgoXCallBack callback) {
        return JobClientFactory.get().asyncCommit(this.context, commitTimeout, runningTimeout, timeUnit, callback);
    }

    public static int getJobProgress(String jobId) {
        return JobClientFactory.get().getJobProgress(jobId);
    }

    @SdkInternal
    public JobContext getContext() {
        return this.context;
    }

    public DataSet readDataSet(String id) {
        return DataChannels.readDataSet("algox", id);
    }

    @SdkInternal
    public String toDataSetCacheId(String id) {
        return DataChannels.toDataSetCacheId(id);
    }

    public void setTitle(String title) {
        this.context.setTitle(title);
    }

    public void setRegion(String region) {
        this.context.setRegion(region);
        this.handleClusterRegion(this.context.getJobName(), region);
    }

    private void handleClusterRegion(String jobName, String jobRegion) {
        String clusterRegion = JobRegionMapping.get().mappingClusterRegion(jobName, jobRegion);
        if (clusterRegion != null) {
            this.context.setRegion(clusterRegion);
        }
    }
}

