/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.core;

import java.util.ArrayList;
import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.sql.parser.SqlParser;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.UnaryExpr;
import kd.bos.algo.sql.tree.agg.CountExpr;
import kd.bos.algo.sql.tree.agg.IAgg;
import kd.bos.algo.sql.tree.agg.MaxExpr;
import kd.bos.algo.sql.tree.agg.MinExpr;
import kd.bos.algo.sql.tree.agg.SumExpr;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.algox.core.AbstractDataSetX;
import kd.bos.algox.core.AggField;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.util.AlgoXUtil;

public class AggregatorDataSetX
extends AbstractDataSetX {
    public static final int SUM = 0;
    public static final int COUNT = 1;
    public static final int MAX = 2;
    public static final int MIN = 3;
    protected static final String[] funcNames = new String[]{"sum", "count", "max", "min"};
    private Grouper groupBy;
    private ArrayList<AggField> aggFieldList = new ArrayList(4);
    private GroupbyInfo info = new GroupbyInfo();
    private SqlParser parser = new SqlParser();

    public AggregatorDataSetX(JobContext context, DataSetX source, Grouper groupBy, AggField aggField) {
        super(context, source);
        this.groupBy = groupBy;
        if (groupBy != null && groupBy.getFields() != null) {
            for (String field : groupBy.getFields()) {
                this.info.addGroup(field);
            }
            this.location = AlgoXUtil.getCallLocationName(5);
        }
        this.addAggField(aggField);
    }

    public Grouper getGroupBy() {
        return this.groupBy;
    }

    public ArrayList<AggField> getAggFieldList() {
        return this.aggFieldList;
    }

    public GroupbyInfo getInfo() {
        return this.info;
    }

    @Override
    public AggregatorDataSetX aggregate(int func, String field, String alias) {
        this.addAggField(new AggField(func, field, alias));
        return this;
    }

    private void addAggField(AggField aggField) {
        this.aggFieldList.add(aggField);
        switch (aggField.func) {
            case 0: {
                Expr child = this.parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                UnaryExpr expr = new SumExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                this.info.addAgg(expr);
                break;
            }
            case 2: {
                Expr child = this.parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                UnaryExpr expr = new MaxExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                this.info.addAgg(expr);
                break;
            }
            case 3: {
                Expr child = this.parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                UnaryExpr expr = new MinExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                this.info.addAgg(expr);
                break;
            }
            case 1: {
                Expr child = this.parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                UnaryExpr expr = new CountExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                this.info.addAgg(expr);
                break;
            }
        }
    }

    @Override
    protected RowMeta createRowMeta() {
        RowMeta innerRowType = ((AbstractDataSetX)this.getSource()).getRowMeta();
        ExprParser executor = new ExprParser(innerRowType);
        Alias[] aggAliasExprs = executor.transformAlias(executor.resolve(this.info.getAggExprs()));
        ArrayList<Field> targetFields = new ArrayList<Field>();
        if (this.groupBy != null && this.groupBy.getFields() != null && this.groupBy.getFields().length > 0) {
            Alias[] groupExprs = new Alias[this.groupBy.getFields().length];
            for (int i = 0; i < groupExprs.length; ++i) {
                Expr expr = executor.parse(this.groupBy.getFields()[i]);
                groupExprs[i] = executor.transformAlias(expr);
                Field targetField = new Field(groupExprs[i].getAlias(), expr.getDataType());
                targetFields.add(targetField);
            }
        }
        for (int i = 0; i < aggAliasExprs.length; ++i) {
            IAgg aggExpr = (IAgg)((Object)aggAliasExprs[i].getChild());
            String alias = aggAliasExprs[i].getAlias();
            DataType dataType = aggExpr.getDataType();
            Field targetField = new Field(alias, dataType);
            targetFields.add(targetField);
        }
        RowMeta rowMeta = new RowMeta(targetFields.toArray(new Field[targetFields.size()]));
        return rowMeta;
    }
}

