/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.region;

import kd.bos.algox.region.FullMatcher;
import kd.bos.algox.region.MappingParser;
import kd.bos.algox.region.RegionMatcher;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;

public class JobRegionMapping {
    private static final Log log = LogFactory.getLog(JobRegionMapping.class);
    private RegionMatcher jobNameMatcher;
    private RegionMatcher jobRegionMatcher;

    private JobRegionMapping() {
        String defaultMapping = System.getProperty("algox.region.jobMappingClusterRegion");
        this.initMatcher(defaultMapping);
        ConfigurationUtil.observeString((String)"algox.region.jobMappingClusterRegion", (String)"", this::initMatcher);
    }

    private synchronized void initMatcher(String text) {
        if (text == null || text.isEmpty()) {
            this.jobNameMatcher = new FullMatcher();
            this.jobRegionMatcher = new FullMatcher();
            return;
        }
        MappingParser parser = new MappingParser();
        try {
            MappingParser.Mapping mapping = parser.parse(text);
            if (mapping != null) {
                this.jobNameMatcher = new FullMatcher(mapping.getNameMapping());
                this.jobRegionMatcher = new FullMatcher(mapping.getRegionMapping());
            }
        }
        catch (Exception exception) {
            log.warn("init job region mapping fail; ex: " + exception.getMessage(), (Throwable)exception);
            this.jobNameMatcher = new FullMatcher();
            this.jobRegionMatcher = new FullMatcher();
        }
    }

    public String mappingClusterRegion(String jobName, String jobRegion) {
        String clusterRegion = this.jobNameMatcher.match(jobName);
        if (clusterRegion != null) {
            return clusterRegion;
        }
        return this.jobRegionMatcher.match(jobRegion);
    }

    public static JobRegionMapping get() {
        return Holder.JOB_REGION_MAPPING;
    }

    private static class Holder {
        private static final JobRegionMapping JOB_REGION_MAPPING = new JobRegionMapping();

        private Holder() {
        }
    }
}

