/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.instance.Instance;
import kd.bos.orm.datasync.DtsAccountPowerListener;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkPublic
public class DtsAccountPower {
    private static final Logger logger = LoggerFactory.getLogger(DtsAccountPower.class);
    private static final Map<String, Boolean> accountDtsPower = new ConcurrentHashMap<String, Boolean>(8);
    private static final Map<String, DtsAccountPowerListener> listeners = new ConcurrentHashMap<String, DtsAccountPowerListener>(1);
    private static AtomicInteger index;

    @SdkInternal
    public static void registerListener(DtsAccountPowerListener listener) {
        String key = listener.getClass().getName();
        listeners.computeIfAbsent(key, k -> listener);
    }

    @SdkInternal
    public static void removeListener(String key) {
        listeners.remove(key);
    }

    public static boolean isAccountDtsEnable() {
        RequestContext rc = RequestContext.get();
        if (rc == null) {
            return false;
        }
        if (DtsAccountPower.isDtsEnable()) {
            if (DtsAccountPower.isAllAccountEnable()) {
                return true;
            }
            String accountId = rc.getAccountId();
            String tenantId = rc.getTenantId();
            return accountDtsPower.getOrDefault(DtsAccountPower.getAccountKey(tenantId, accountId), false);
        }
        return false;
    }

    @SdkInternal
    public static synchronized void setAccountDtsPower(Account account) {
        String accountKey = DtsAccountPower.getAccountKey(account.getTenantId(), account.getAccountId());
        Exception e = new Exception();
        logger.warn(String.format("setAccountDtsPower:[%s] = %s", accountKey, account.isDtsEnable()), (Throwable)e);
        if (Instance.getClusterName().indexOf("smoke") > 0) {
            System.setProperty(String.format("%s_setAccountDtsPower[%s]=%s", index.getAndIncrement(), accountKey, account.isDtsEnable()), ExceptionLogger.getStack((Throwable)e));
        }
        accountDtsPower.put(accountKey, account.isDtsEnable());
    }

    private static void notifyAccountDtsPower(Account account) {
        if (!DtsAccountPower.isDtsEnable()) {
            return;
        }
        String accountKey = DtsAccountPower.getAccountKey(account.getTenantId(), account.getAccountId());
        Boolean orign = accountDtsPower.get(accountKey);
        if (orign != null) {
            if (!orign.booleanValue() && account.isDtsEnable()) {
                logger.debug("DtsAccountPower account enable:" + accountKey);
                listeners.forEach((k, listener) -> listener.enable(account));
            }
            if (orign.booleanValue() && !account.isDtsEnable()) {
                logger.debug("DtsAccountPower account disable:" + accountKey);
                listeners.forEach((k, listener) -> listener.disable(account));
            }
        } else if (account.isDtsEnable()) {
            logger.debug("DtsAccountPower account enable for added:" + accountKey);
            listeners.forEach((k, listener) -> listener.enable(account));
        }
    }

    private static String getAccountKey(String tenantId, String accountId) {
        return tenantId + "#" + accountId;
    }

    private static boolean isDtsEnable() {
        return Boolean.parseBoolean(System.getProperty("dts.sync.enable", "true"));
    }

    private static boolean isAllAccountEnable() {
        return Boolean.getBoolean("dts.sync.allAccount.enable.fordev");
    }

    static {
        TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
            }

            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
            }

            public void onTenantChanged(TenantListenerInfo tenantListenerInfo) {
                logger.info("DtsAccountPower.onTenantChanged");
                for (Account account : tenantListenerInfo.getAccountList()) {
                    DtsAccountPower.notifyAccountDtsPower(account);
                    DtsAccountPower.setAccountDtsPower(account);
                }
            }
        }, (int)1000);
        index = new AtomicInteger(0);
    }
}

