/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class DtsPower {
    private static final String DTS_BUSINESSTYPE_PRE = "dts.businesstype.%s.enable";
    private static final String DTS_BUSINESSTYPE_WHITE_LIST = "dts.businesstype.%s.whitelist";
    private static final Map<String, Set<String>> whiteList = new ConcurrentHashMap<String, Set<String>>();

    public static boolean isBusinessTypeEnable(String businessType) {
        if (businessType == null || businessType.length() == 0) {
            businessType = "default";
        }
        Set WhiteAccountSet = whiteList.computeIfAbsent(businessType, k -> {
            final String whitelistKey = String.format(DTS_BUSINESSTYPE_WHITE_LIST, k);
            String whiteListStr = System.getProperty(whitelistKey);
            final HashSet<String> accountSet = new HashSet<String>();
            if (whiteListStr != null && whiteListStr.length() > 0) {
                String[] accountIds;
                for (String accountId : accountIds = whiteListStr.split(",|;")) {
                    accountSet.add(accountId);
                }
            }
            ConfigurationUtil.observeChange((String)whitelistKey, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    String whiteListStr = System.getProperty(whitelistKey);
                    accountSet.clear();
                    if (whiteListStr != null && whiteListStr.length() > 0) {
                        String[] accountIds;
                        for (String accountId : accountIds = whiteListStr.split(",|;")) {
                            accountSet.add(accountId);
                        }
                    }
                }
            });
            return accountSet;
        });
        boolean businessTypeEnable = Boolean.parseBoolean(System.getProperty(String.format(DTS_BUSINESSTYPE_PRE, businessType), "true"));
        if (WhiteAccountSet.isEmpty()) {
            return businessTypeEnable;
        }
        return businessTypeEnable && WhiteAccountSet.contains(RequestContext.get().getAccountId());
    }
}

