/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsPower;

public class BusinessTypeEnable {
    private static Log logger = LogFactory.getLog(BusinessTypeEnable.class);
    public static BusinessTypeEnable instance = new BusinessTypeEnable();
    Map<String, Boolean> businessTypeEnableMap = new ConcurrentHashMap<String, Boolean>(4);

    private BusinessTypeEnable() {
    }

    public boolean isBusinessTypeEnable(String businessType) {
        return this.businessTypeEnableMap.computeIfAbsent(businessType, k -> {
            boolean bussinessEnable = DtsPower.isBusinessTypeEnable(businessType);
            if (!bussinessEnable) {
                logger.warn("dts businesstype disabled: " + businessType);
            }
            return bussinessEnable;
        });
    }
}

