/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.agent.CollectEntityTableUtil;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.datasync.agent.MetaTable;
import kd.bos.orm.datasync.agent.TableInfo;
import kd.bos.orm.datasync.agent.UpgraderColumnParenttable;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationTablesCache {
    Logger log = LoggerFactory.getLogger(RelationTablesCache.class);
    private static Map<String, RelationTablesCache> instances = new ConcurrentHashMap<String, RelationTablesCache>(2);
    private ConcurrentHashMap<String, String> tableNameMap = new ConcurrentHashMap(8);
    private ConcurrentHashMap<String, Set<TableInfo>> relationTablesMap = new ConcurrentHashMap(8);
    private ConcurrentHashMap<String, Set<TableInfo>> defaultRelationTablesMap = new ConcurrentHashMap(8);

    private RelationTablesCache() {
    }

    public static RelationTablesCache get() {
        String accountId = RequestContext.get().getAccountId();
        return instances.computeIfAbsent(accountId, v -> new RelationTablesCache());
    }

    public Set<TableInfo> getEntityTableInfos(String entityNumber) {
        return this.defaultRelationTablesMap.computeIfAbsent(entityNumber, k -> this.getDefaultTableInfos(entityNumber));
    }

    public void reloadEntityTableConfig(String entityNumber) {
        this.defaultRelationTablesMap.put(entityNumber, this.getRelationTableConfig(entityNumber, "1"));
    }

    public void putTableNameEntityNumber(String tableName, String entityNumber) {
        this.tableNameMap.put(tableName.toLowerCase(), entityNumber);
    }

    public String getEntityNumberByTableName(String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.tableNameMap.get(tableName.toLowerCase());
    }

    public Set<String> getTableNamesByEntityNumber(String entityNumber) {
        HashSet<String> tables = new HashSet<String>(16);
        try {
            for (TableInfo tableInfo : this.getEntityTableInfos(entityNumber)) {
                tables.add(tableInfo.getTableName());
            }
            for (TableInfo tableInfo : this.getRelationTableInfos(entityNumber)) {
                tables.add(tableInfo.getTableName());
            }
        }
        catch (Exception e) {
            ExceptionLogger.error(DataSyncConfigCache.class, (String)String.format("dts getTableNamesByEntityNumber %s error", entityNumber), (Throwable)e);
        }
        return tables;
    }

    public Set<TableInfo> getRelationTableInfos(String entityNumber) {
        if (!this.relationTablesMap.containsKey(entityNumber)) {
            this.reloadRelationTableConfig(entityNumber);
        }
        return this.relationTablesMap.get(entityNumber);
    }

    public void reloadRelationTableConfig(String entityNumber) {
        this.relationTablesMap.put(entityNumber, this.getRelationTableConfig(entityNumber, "0"));
    }

    public Set<TableInfo> getEntityTable(String entityNumber) {
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        HashSet<String> tables = new HashSet<String>(10);
        HashSet<TableInfo> tableInfoSet = new HashSet<TableInfo>(10);
        String tableName = entityType.getAlias().toLowerCase();
        tables.add(tableName);
        AtomicBoolean hasMultiFiled = new AtomicBoolean(false);
        entityType.getProperties().forEach(v -> {
            if (!(v instanceof DynamicCollectionProperty)) {
                try {
                    String tableGroup;
                    String alias;
                    if (Class.forName("kd.bos.entity.property.MuliLangTextProp").isAssignableFrom(v.getClass())) {
                        hasMultiFiled.set(true);
                    }
                    if ((alias = v.getAlias()) == null || alias.length() <= 0 || (tableGroup = v.getTableGroup()) == null) return;
                    tables.add(tableName + "_" + tableGroup.toLowerCase());
                    return;
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.findPropertyFailed, new Object[]{"MuliLangTextProp not found"});
                }
            }
            try {
                if (!Class.forName("kd.bos.entity.property.EntryProp").isAssignableFrom(v.getClass()) || ((DynamicCollectionProperty)v).getItemType().getAlias() == null) return;
                DynamicCollectionProperty entry = (DynamicCollectionProperty)v;
                String entryTableName = entry.getItemType().getAlias().toLowerCase();
                if (entryTableName.length() > 0) {
                    tables.add(entryTableName);
                }
                entry.getItemType().getProperties().forEach(p -> {
                    String tableGroup;
                    String alias = p.getAlias();
                    if (!(p instanceof DynamicCollectionProperty) && alias != null && alias.length() > 0 && (tableGroup = p.getTableGroup()) != null) {
                        tables.add(entryTableName + "_" + tableGroup.toLowerCase());
                    }
                });
                return;
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.findPropertyFailed, new Object[]{"EntryProp not found"});
            }
        });
        if (hasMultiFiled.get()) {
            tables.add(tableName + "_l");
        }
        String relationField = entityType.getPrimaryKey().getAlias().toLowerCase();
        for (String table : tables) {
            tableInfoSet.add(new TableInfo(table, relationField));
        }
        return tableInfoSet;
    }

    public Set<TableInfo> getDefaultTableInfos(String entityNumber) {
        this.doFlushRelationTables(entityNumber, false);
        Set<TableInfo> tableInfoSet = this.getRelationTableConfig(entityNumber, "1");
        return tableInfoSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlushRelationTables(String entityNumber, boolean forceFlush) {
        Set<TableInfo> tableInfoSet = this.getRelationTableConfig(entityNumber, "1");
        if (forceFlush || this.isFlushDefaultTablesConfig(entityNumber, tableInfoSet)) {
            this.log.info(MessageFormat.format("RelationTablesCache#doFlushRelationTables flush begin,entitynumber:{0}, forceFlush:{1}", entityNumber, forceFlush));
            String lockKey = this.getInsertDefaultTablesLockKey(entityNumber);
            DLock lock = DLock.create((String)lockKey);
            if (lock.tryLock(120000L)) {
                block4: {
                    this.log.info(MessageFormat.format("RelationTablesCache#doFlushRelationTables lockinto,entitynumber:{0}, lockKey:{1}", entityNumber, lockKey));
                    try {
                        tableInfoSet = this.getRelationTableConfig(entityNumber, "1");
                        if (!forceFlush && !this.isFlushDefaultTablesConfig(entityNumber, tableInfoSet)) break block4;
                        Set<TableInfo> customTableInfoSet = this.getRelationTableConfig(entityNumber, "0");
                        tableInfoSet = CollectEntityTableUtil.collectEntityTables(entityNumber);
                        this.deleteDefaultTablesConfig(entityNumber);
                        this.insertDefaultTablesConfig(customTableInfoSet, entityNumber, tableInfoSet);
                        this.log.info(MessageFormat.format("RelationTablesCache#doFlushRelationTables unlock,entitynumber:{0}, lockKey:{1}", entityNumber, lockKey));
                    }
                    catch (Throwable throwable) {
                        this.log.info(MessageFormat.format("RelationTablesCache#doFlushRelationTables insertDefaultTablesConfig end,entitynumber:{0} ", entityNumber));
                        lock.unlock();
                        throw throwable;
                    }
                }
                this.log.info(MessageFormat.format("RelationTablesCache#doFlushRelationTables insertDefaultTablesConfig end,entitynumber:{0} ", entityNumber));
                lock.unlock();
            }
        }
    }

    public void flushRelationTables(String entityNumber) {
        this.doFlushRelationTables(entityNumber, true);
        DataSyncConfigCache dscc = DataSyncConfigCache.get();
        this.reloadRelationTableConfig(entityNumber);
        this.reloadEntityTableConfig(entityNumber);
        dscc.removeCache();
    }

    private boolean isFlushDefaultTablesConfig(String entityNumber, Set<TableInfo> tableInfoSet) {
        boolean isFlush = false;
        long count = this.countRelationTableConfig(entityNumber);
        if (count > 1L) {
            MessageFormat.format("RelationTablesCache#doFlushRelationTables isFlushDefaultTablesConfig,entitynumber:{0}, count:{1}", entityNumber, count);
            isFlush = true;
        } else if (tableInfoSet.isEmpty()) {
            MessageFormat.format("RelationTablesCache#doFlushRelationTables isFlushDefaultTablesConfig,entitynumber:{0}, empty", entityNumber);
            isFlush = true;
        } else if (UpgraderColumnParenttable.isUpgraded()) {
            for (TableInfo tableInfo : tableInfoSet) {
                if (!StringUtils.isEmpty((String)tableInfo.getParenttable()) || tableInfo.getLevel() == 1) continue;
                MessageFormat.format("RelationTablesCache#doFlushRelationTables isFlushDefaultTablesConfig,entitynumber:{0}, parenttable empty", entityNumber);
                isFlush = true;
                break;
            }
        }
        return isFlush;
    }

    private String getInsertDefaultTablesLockKey(String entityName) {
        RequestContextInfo rc = RequestContextInfo.get();
        return "/dts/insert_table/" + rc.getAccountId() + "/" + entityName;
    }

    /*
     * Exception decompiling
     */
    private Set<TableInfo> getRelationTableConfig(String entityNumber, String configType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void insertDefaultTablesConfig(Set<TableInfo> customTableInfoSet, String entityNumber, Set<TableInfo> tableSet) {
        String mainSql = "INSERT INTO T_DTS_TABLE_CONFIG(FID, FENTITYNUMBER) VALUES(?, ?)";
        StringBuilder entrySql = new StringBuilder();
        entrySql.append("INSERT INTO T_DTS_TABLE_CONFIG_ENTRY(FID, FENTRYID, FSEQ, FRELATIONTABLE, FRELATIONFIELD, FCONFIGTYPE");
        if (UpgraderColumnParenttable.isUpgraded()) {
            entrySql.append(",FNAME,FPRIMARYKEY,FPARENTTABLE,FPARENTFIELD,FLEVEL");
        }
        entrySql.append(") VALUES(?, ?, ?, ?, ?, ?");
        if (UpgraderColumnParenttable.isUpgraded()) {
            entrySql.append(",?, ?, ?, ?, ?");
        }
        entrySql.append(")");
        long mainId = DB.genGlobalLongId();
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
             TXHandle h = TX.requiresNew();){
            Object[] param;
            String parentfield;
            String parenttable;
            String primaryKey;
            String name;
            DB.execute((DBRoute)DBRoute.basedata, (String)"INSERT INTO T_DTS_TABLE_CONFIG(FID, FENTITYNUMBER) VALUES(?, ?)", (Object[])new Object[]{mainId, entityNumber});
            long[] entryIds = DB.genGlobalLongIds((int)tableSet.size());
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(tableSet.size());
            int i = 0;
            for (TableInfo tableInfo : tableSet) {
                if (UpgraderColumnParenttable.isUpgraded()) {
                    name = StringUtils.isEmpty((String)tableInfo.getName()) ? " " : tableInfo.getName();
                    primaryKey = StringUtils.isEmpty((String)tableInfo.getPrimaryKey()) ? " " : tableInfo.getPrimaryKey();
                    parenttable = StringUtils.isEmpty((String)tableInfo.getParenttable()) ? " " : tableInfo.getParenttable();
                    parentfield = StringUtils.isEmpty((String)tableInfo.getParentfield()) ? " " : tableInfo.getParentfield();
                    param = new Object[]{mainId, entryIds[i], i + 1, tableInfo.getTableName(), tableInfo.getRelationField(), "1", name, primaryKey, parenttable, parentfield, tableInfo.getLevel()};
                } else {
                    param = new Object[]{mainId, entryIds[i], i + 1, tableInfo.getTableName(), tableInfo.getRelationField(), "1"};
                }
                paramsList.add(param);
                ++i;
            }
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)entrySql.toString(), paramsList);
            if (!customTableInfoSet.isEmpty()) {
                entryIds = DB.genGlobalLongIds((int)customTableInfoSet.size());
                paramsList = new ArrayList(customTableInfoSet.size());
                i = 0;
                for (TableInfo tableInfo : customTableInfoSet) {
                    if (UpgraderColumnParenttable.isUpgraded()) {
                        name = StringUtils.isEmpty((String)tableInfo.getName()) ? " " : tableInfo.getName();
                        primaryKey = StringUtils.isEmpty((String)tableInfo.getPrimaryKey()) ? " " : tableInfo.getPrimaryKey();
                        parenttable = StringUtils.isEmpty((String)tableInfo.getParenttable()) ? " " : tableInfo.getParenttable();
                        parentfield = StringUtils.isEmpty((String)tableInfo.getParentfield()) ? " " : tableInfo.getParentfield();
                        param = new Object[]{mainId, entryIds[i], i + 1, tableInfo.getTableName(), tableInfo.getRelationField(), "0", name, primaryKey, parenttable, parentfield, tableInfo.getLevel()};
                    } else {
                        param = new Object[]{mainId, entryIds[i], i + 1, tableInfo.getTableName(), tableInfo.getRelationField(), "0"};
                    }
                    paramsList.add(param);
                    ++i;
                }
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)entrySql.toString(), paramsList);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private long countRelationTableConfig(String entityNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteDefaultTablesConfig(String entityNumber) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT FID FROM T_DTS_TABLE_CONFIG WHERE FENTITYNUMBER = ? ");
        StringBuilder mainSql = new StringBuilder();
        mainSql.append("DELETE FROM T_DTS_TABLE_CONFIG WHERE FENTITYNUMBER = ? ");
        List existIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])new Object[]{entityNumber}, rs -> {
            ArrayList<Long> ret = new ArrayList<Long>(1);
            while (rs.next()) {
                ret.add(rs.getLong("FID"));
            }
            return ret;
        });
        StringBuilder entrySql = new StringBuilder();
        entrySql.append("DELETE FROM T_DTS_TABLE_CONFIG_ENTRY WHERE FID IN(");
        ArrayList paramsList = new ArrayList(1);
        for (int i = 0; i < existIds.size(); ++i) {
            entrySql.append("?");
            paramsList.add(existIds.get(i));
            if (i == existIds.size() - 1) continue;
            entrySql.append(",");
        }
        entrySql.append(" ) ");
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
             TXHandle h = TX.requiresNew();){
            if (!existIds.isEmpty()) {
                StringBuilder paramStr = new StringBuilder();
                for (int i = 0; i < paramsList.size(); ++i) {
                    paramStr.append(paramsList.get(i).toString());
                    if (i == paramsList.size() - 1) continue;
                    paramStr.append(",");
                }
                this.log.info(MessageFormat.format("RelationTablesCache#getDefaultTableInfosdoArchive deleteDefaultTablesConfig,entrySql:{0}, entityNumber:{1}, paramsList:{2}", entrySql.toString(), entityNumber, paramStr));
                DB.execute((DBRoute)DBRoute.basedata, (String)entrySql.toString(), (Object[])paramsList.toArray());
            }
            DB.execute((DBRoute)DBRoute.basedata, (String)mainSql.toString(), (Object[])new Object[]{entityNumber});
            this.log.info(MessageFormat.format("RelationTablesCache#getDefaultTableInfosdoArchive deleteDefaultTablesConfig,mainSql:{0}, entityNumber:{1}", mainSql.toString(), entityNumber));
        }
    }

    public Map<String, MetaTable> getMetaTableMap(String entityNumber) {
        HashMap<String, MetaTable> metaTableMap = new HashMap<String, MetaTable>(8);
        Set<TableInfo> metaTables = this.getEntityTableInfos(entityNumber);
        TableInfo mainTable = (TableInfo)metaTables.stream().filter(item -> item.getLevel() == 1).collect(Collectors.toList()).get(0);
        MetaTable mainMetaTable = new MetaTable(mainTable.getTableName(), mainTable.getPrimaryKey());
        metaTableMap.put(mainMetaTable.getTableName().toLowerCase(), mainMetaTable);
        List childTableList = metaTables.stream().filter(item -> item.getLevel() > 1).collect(Collectors.toList());
        Collections.sort(childTableList, Comparator.comparingInt(TableInfo::getLevel));
        for (TableInfo item2 : childTableList) {
            MetaTable childrenMetaTable = new MetaTable(item2.getTableName(), item2.getPrimaryKey(), item2.getRelationField(), item2.getParentfield(), (MetaTable)metaTableMap.get(item2.getParenttable().toLowerCase()));
            metaTableMap.put(childrenMetaTable.getTableName().toLowerCase(), childrenMetaTable);
        }
        Set<TableInfo> customTables = this.getRelationTableInfos(entityNumber);
        for (TableInfo item3 : customTables) {
            String primaryKey = StringUtils.isEmpty((String)item3.getPrimaryKey()) ? item3.getRelationField() : item3.getPrimaryKey();
            String parentfield = StringUtils.isEmpty((String)item3.getParentfield()) ? item3.getRelationField() : item3.getParentfield();
            MetaTable childrenMetaTable = new MetaTable(item3.getTableName(), primaryKey, item3.getRelationField(), parentfield, (MetaTable)metaTableMap.get(mainTable.getTableName()));
            metaTableMap.put(childrenMetaTable.getTableName().toLowerCase(), childrenMetaTable);
        }
        return metaTableMap;
    }

    private static /* synthetic */ Long lambda$countRelationTableConfig$4(ResultSet rs) throws Exception {
        if (rs.next()) {
            return rs.getLong(1);
        }
        return 0L;
    }
}

