/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.xdb.eventbus.RequestContextInfo;

public final class SyncConfigVersion {
    private static int timeout = 120;
    private final String accountKey;
    private DistributeSessionlessCache configVersionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dts");

    public SyncConfigVersion() {
        RequestContextInfo rc = RequestContextInfo.get();
        this.accountKey = rc.getTenantId() + '#' + rc.getAccountId();
    }

    public long getLastVersion() {
        String version = (String)this.configVersionCache.get(this.getSyncConfigVersionKey());
        if (version != null) {
            try {
                return Long.parseLong(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long cur = System.currentTimeMillis();
        this.configVersionCache.put(this.getSyncConfigVersionKey(), (Object)String.valueOf(cur), timeout, TimeUnit.MINUTES);
        return cur;
    }

    public long incVersion() {
        return this.configVersionCache.inc(this.getSyncConfigVersionKey(), timeout, TimeUnit.MINUTES);
    }

    private final String getSyncConfigVersionKey() {
        return "DTS#SyncConfigVersion#" + this.accountKey;
    }
}

