/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.agent;

import java.lang.reflect.Method;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public class UpgraderStatus {
    public static UpgraderStatus status = new UpgraderStatus();
    private static final Log log = LogFactory.getLog((String)UpgraderStatus.class.getName());
    private static final String preKey = "dts_upgrader_status_";
    private DistributeSessionlessCache cuationStore = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dts");
    private static Method isInstanceAlive = null;

    private UpgraderStatus() {
    }

    public void begin() {
        String accountid = RequestContext.get().getAccountId();
        this.cuationStore.put(preKey + accountid, (Object)Instance.getInstanceId(), 10800);
    }

    public void end() {
        String accountid = RequestContext.get().getAccountId();
        this.cuationStore.remove(preKey + accountid);
        DataSyncConfigCache.get().removeCache();
    }

    public boolean isUpgradering() {
        String accountid = RequestContext.get().getAccountId();
        String upgraderingInstance = (String)this.cuationStore.get(preKey + accountid);
        if (upgraderingInstance == null) {
            return false;
        }
        return UpgraderStatus.isInstanceAlive(upgraderingInstance);
    }

    private static boolean isInstanceAlive(String instanceId) throws KDException {
        try {
            if (isInstanceAlive == null) {
                Method m = Class.forName("kd.bos.monitor.service.LivingServiceUtils").getMethod("isInstanceAlive", String.class);
                m.setAccessible(true);
                isInstanceAlive = m;
            }
            return (Boolean)isInstanceAlive.invoke(null, instanceId);
        }
        catch (Exception e) {
            log.error("isInstanceAlive error", (Throwable)e);
            return false;
        }
    }
}

