/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datasync.send;

import java.lang.reflect.Method;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.datasync.send.MessageSender;

public class MessageSenderImpl
implements MessageSender {
    private static Class<?> dtsMsgSenderClass;
    private static Method dtsMsgSenderMethod;

    public static MessageSender get() {
        return MessagerSenderHolder.instance;
    }

    @Override
    public void send(String region, String queue, Map<String, Object> msg, String routeKey) {
        if (dtsMsgSenderMethod != null) {
            try {
                dtsMsgSenderMethod.invoke(dtsMsgSenderClass, region, queue, msg, routeKey);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"send dts message error"});
            }
        }
    }

    static {
        try {
            Method[] methods;
            dtsMsgSenderClass = Class.forName("kd.bos.dts.DtsMsgSender");
            for (Method m : methods = dtsMsgSenderClass.getDeclaredMethods()) {
                if (!m.getName().equals("sendWithTranscation")) continue;
                dtsMsgSenderMethod = m;
                break;
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"get kd.bos.dts.DtsMsgSender method error"});
        }
    }

    private static class MessagerSenderHolder {
        private static MessageSender instance = new MessageSenderImpl();

        private MessagerSenderHolder() {
        }
    }
}

