/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.container.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kd.bos.cage.commons.CageConstants;
import kd.bos.cage.container.ContainerType;
import kd.bos.cage.container.ICageContainerService;
import kd.bos.cage.container.TenantCageContainer;
import kd.bos.cage.funswitch.CageSwitch;
import kd.bos.cage.tenant.CageTenant;
import kd.bos.cage.tenant.ICageTenantService;
import kd.bos.cage.tenant.impl.CageTenantService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CageContainerService
implements ICageContainerService {
    private static final Log log = LogFactory.getLog(CageContainerService.class);
    private static final int CONTAINER_MAX_LEVEL = 6;
    private static final int CHECK_CPU_CORE_PERIOD = 1000;
    private ICageTenantService tenantService = CageTenantService.getInstance();

    public static ICageContainerService getInstance() {
        return SingletonHolder.instance;
    }

    private CageContainerService() {
    }

    @Override
    public void addPidToContainer(ContainerType type, int pid, String toContainerPath) {
        if (type != null && StringUtils.isNotEmpty((String)toContainerPath)) {
            StringBuilder absolutePath = new StringBuilder(CageConstants.CAGE_ROOT_PATH).append(type.toString()).append(toContainerPath).append(CageConstants.TASKS_FILE_NAME);
            ArrayList<String> pidList = new ArrayList<String>(1);
            pidList.add(String.valueOf(pid));
            boolean result = this.writeContentToFile(absolutePath.toString(), pidList, true);
            if (!result) {
                log.error("Cage to control pid={},container path={},type={} failure !", new Object[]{pid, toContainerPath, type.toString()});
            }
        }
    }

    @Override
    public void delPidFromContainer(ContainerType containerType, int pid) {
        StringBuilder absolutePath = new StringBuilder(CageConstants.CAGE_ROOT_PATH).append(containerType.toString()).append(CageConstants.TASKS_FILE_NAME);
        ArrayList<String> listPId = new ArrayList<String>(1);
        listPId.add(String.valueOf(pid));
        boolean result = this.writeContentToFile(absolutePath.toString(), listPId, true);
        if (!result) {
            log.error("Cage to forcePidExitContainer pid={},container type={} failure!", (Object)pid, (Object)containerType.toString());
        }
    }

    @Override
    public void destroyContainer(String containerPath) {
        ContainerType[] containerTypes;
        if (StringUtils.isEmpty((String)containerPath) || !containerPath.startsWith("/kd-cage")) {
            return;
        }
        for (ContainerType type : containerTypes = ContainerType.values()) {
            String typeValue = type.toString();
            ArrayList<String> pidList = new ArrayList<String>();
            if (typeValue.equals(ContainerType.tenant.toString()) || typeValue.equals(ContainerType.mem.toString())) continue;
            try {
                StringBuilder cageRootPathOfType = new StringBuilder();
                cageRootPathOfType.append(CageConstants.CAGE_ROOT_PATH).append(typeValue).append(containerPath);
                String[] subContainerDir = CageContainerService.traverseDir(cageRootPathOfType.toString());
                if (subContainerDir == null || subContainerDir.length == 0) {
                    return;
                }
                for (String containerDir : subContainerDir) {
                    pidList.addAll(Files.readAllLines(Paths.get(containerDir + CageConstants.TASKS_FILE_NAME, new String[0]), StandardCharsets.UTF_8));
                }
                this.batchMovePIdsToRootTasks(pidList, typeValue);
                this.batchDelContainerDirs(cageRootPathOfType.toString(), subContainerDir);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    @Override
    public void buildAllTenantContainers() {
        List<CageTenant> list = this.tenantService.listAllTenants();
        for (CageTenant tenant : list) {
            TenantCageContainer tenantKDContainer = new TenantCageContainer(tenant.getTenantId());
            tenantKDContainer.setRelativePath(tenant.getRelativePath());
            tenantKDContainer.build();
            String quota = this.tenantService.getTenantQuota(tenant.getTenantId());
            tenantKDContainer.updateQuota(quota);
            tenant.setTenantContainer(tenantKDContainer);
        }
    }

    @Override
    public void createContainer(ContainerType containerType, String containerPath) {
        if (StringUtils.isNotEmpty((String)containerPath) && containerPath.startsWith("/kd-cage")) {
            StringBuilder absolutePath = new StringBuilder(CageConstants.CAGE_ROOT_PATH).append(containerType.toString()).append(containerPath);
            File file = new File(absolutePath.toString());
            if (file.exists()) {
                this.destroyContainer(containerPath);
            }
            try {
                boolean result = file.mkdirs();
                if (!result) {
                    log.error("Cage create container for path=[{}],mkdirs() return {}", (Object)containerPath, (Object)false);
                }
            }
            catch (Exception e) {
                log.error("Cage create container for path=[{}],error-> {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public void updateContainerQuota(ContainerType containerType, String containerPath, String quotaFileName, String quota) {
        if (containerType != null && StringUtils.isNotEmpty((String)containerPath) && containerPath.startsWith("/kd-cage") && StringUtils.isNotEmpty((String)quotaFileName) && StringUtils.isNotEmpty((String)quota)) {
            StringBuilder quotaFilePath = new StringBuilder(CageConstants.CAGE_ROOT_PATH).append(containerType.toString()).append(containerPath).append(File.separator).append(quotaFileName);
            File quotaFile = new File(quotaFilePath.toString());
            if (quotaFile.exists()) {
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(quota);
                boolean updateResult = this.writeContentToFile(quotaFilePath.toString(), list, false);
                if (!updateResult) {
                    log.error("Cage update quota failure,container path=[{}],quota={}", (Object)containerPath, (Object)quota);
                }
            } else {
                log.error("Cage pdate container quota file for path={},not existed!", (Object)quotaFile.getAbsolutePath());
            }
        }
    }

    @Override
    public void monitorCpuCoreNumberChanged() {
        CompletableFuture.runAsync(() -> {
            try {
                int coreNumber = Runtime.getRuntime().availableProcessors();
                while (true) {
                    Thread.sleep(1000L);
                    if (!CageSwitch.isOn()) {
                        return;
                    }
                    int coreNumberNow = Runtime.getRuntime().availableProcessors();
                    if (coreNumberNow == coreNumber) continue;
                    log.info("CPU cores size from {} to {}", (Object)coreNumber, (Object)coreNumberNow);
                    List<CageTenant> list = this.tenantService.listAllTenants();
                    list.forEach(cageTenant -> {
                        TenantCageContainer container = cageTenant.getTenantContainer();
                        if (container != null) {
                            container.updateQuota(this.tenantService.getTenantQuota(cageTenant.getTenantId()));
                        }
                    });
                    coreNumber = coreNumberNow;
                }
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
                return;
            }
        });
    }

    private void batchMovePIdsToRootTasks(List<String> pidList, String type) {
        if (!pidList.isEmpty()) {
            StringBuilder typeRootPathOfType = new StringBuilder();
            typeRootPathOfType.append(CageConstants.CAGE_ROOT_PATH).append(type).append(CageConstants.TASKS_FILE_NAME);
            pidList.forEach(pid -> {
                try (FileWriter fw = new FileWriter(typeRootPathOfType.toString(), true);){
                    fw.write((String)pid);
                }
                catch (Exception ioe) {
                    log.error((Throwable)ioe);
                }
            });
        }
    }

    private void batchDelContainerDirs(String containerDir, String[] subContainerDirs) {
        for (String subContainerDir : subContainerDirs) {
            File subContainerDirFile = new File(subContainerDir);
            if (!subContainerDirFile.delete()) {
                log.error("Destroy sub container dir  error,file={}", (Object)subContainerDirFile.getAbsolutePath());
                continue;
            }
            String tenantId = subContainerDirFile.getName();
            CageTenant tenant = this.tenantService.getTenantById(tenantId);
            if (tenant == null || tenant.getTenantContainer() == null) continue;
            tenant.setTenantContainer(null);
        }
        File containerDirFile = new File(containerDir);
        if (!containerDirFile.delete()) {
            log.error("Destroy container dir  error,file={}", (Object)containerDir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeContentToFile(String filePath, List<String> contents, boolean append) {
        if (!StringUtils.isNotEmpty((String)filePath)) return false;
        if (!filePath.startsWith(CageConstants.CAGE_ROOT_PATH)) return false;
        if (contents == null) return false;
        if (contents.isEmpty()) return false;
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        try (FileWriter fw = new FileWriter(filePath, append);){
            for (String content : contents) {
                fw.write(content);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return true;
        }
    }

    private static String[] traverseDir(String filePath) {
        String[] orderedByLevel = null;
        if (filePath.startsWith(CageConstants.CAGE_ROOT_PATH)) {
            ArrayList<DirInfo> dirSet2 = new ArrayList<DirInfo>();
            CageContainerService.traverseDirHelper(new File(filePath), dirSet2, 0);
            dirSet2.sort((dir1, dir2) -> ((DirInfo)dir2).level - ((DirInfo)dir1).level);
            orderedByLevel = new String[dirSet2.size()];
            int index = 0;
            for (DirInfo dirInfo : dirSet2) {
                orderedByLevel[index] = dirInfo.path;
                ++index;
            }
        }
        return orderedByLevel;
    }

    private static void traverseDirHelper(File dir, List<DirInfo> dirSet, int level) {
        if (!dir.exists() && dir.isFile() || 6 < level) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        DirInfo info = new DirInfo(dir.getPath(), ++level);
        dirSet.add(info);
        for (File file : files) {
            if (!file.isDirectory()) continue;
            CageContainerService.traverseDirHelper(file, dirSet, level);
        }
    }

    private static class DirInfo {
        private String path;
        private int level;

        DirInfo(String path, int level) {
            this.path = path;
            this.level = level;
        }
    }

    private static class SingletonHolder {
        private static final ICageContainerService instance = new CageContainerService();

        private SingletonHolder() {
        }
    }
}

