/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.funswitch;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.cage.funswitch.ICageSwitchStatusListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CageSwitch {
    private static Log log = LogFactory.getLog(CageSwitch.class);
    private static volatile boolean cageIsOn = false;
    private static String switchDefaultKey = "cageSwitch";
    private static Map<String, String> switchCfg = new HashMap<String, String>();
    private static Map<String, String> switchCfgLast = new HashMap<String, String>();
    private static List<ICageSwitchStatusListener> listenerList = new ArrayList<ICageSwitchStatusListener>();
    public static final String APP_NAME = System.getProperty("appName", "Unknown");
    public static final String ON_STATUS = "ON";
    public static final String OFF_STATUS = "OFF";
    private static final String CHECK_RUNTIME_ENV_CGROUP_SHELL_CMD = "/bin/bash -c  mount cgroup";
    private static final String KEYWORD_CHECK_CGROUP_RUNTIME_ENV = "cpu,cpuacct type cgroup";
    private static final String FLAG_TEST_CAGE_ID = "kd-cage-test";
    private static boolean cgroupRuntimeEnv = false;

    private CageSwitch() {
    }

    public static void updatedSwitch(Map<String, String> newConfig) {
        if (!cgroupRuntimeEnv) {
            return;
        }
        switchCfgLast.clear();
        switchCfgLast.putAll(switchCfg);
        String switchHisStatus = switchCfgLast.get(switchDefaultKey);
        String switchCurrentStatus = newConfig.get(switchDefaultKey);
        if (switchHisStatus.equals(OFF_STATUS) && switchCurrentStatus.equals(ON_STATUS)) {
            if (newConfig.containsKey(APP_NAME)) {
                cageIsOn = false;
                return;
            }
            cageIsOn = true;
            listenerList.forEach(listener -> listener.notify(ON_STATUS));
        } else if (switchHisStatus.equals(ON_STATUS) && switchCurrentStatus.equals(OFF_STATUS)) {
            cageIsOn = false;
            listenerList.forEach(listener -> listener.notify(OFF_STATUS));
        } else if (switchHisStatus.equals(ON_STATUS) && switchCurrentStatus.equals(ON_STATUS)) {
            if (newConfig.containsKey(APP_NAME)) {
                cageIsOn = false;
                listenerList.forEach(listener -> listener.notify(OFF_STATUS));
            } else if (switchCfgLast.containsKey(APP_NAME) && !newConfig.containsKey(APP_NAME)) {
                cageIsOn = true;
                listenerList.forEach(listener -> listener.notify(ON_STATUS));
            }
        }
        switchCfg = new HashMap<String, String>();
        switchCfg.putAll(newConfig);
    }

    public static boolean isOn() {
        return cageIsOn;
    }

    public static boolean cgroupRuntimeEnvIsOn() {
        return cgroupRuntimeEnv;
    }

    private static void registerSwitchStatusListeners() {
        ServiceLoader<ICageSwitchStatusListener> listeners = ServiceLoader.load(ICageSwitchStatusListener.class);
        listeners.forEach(listener -> listenerList.add((ICageSwitchStatusListener)listener));
    }

    /*
     * Exception decompiling
     */
    private static boolean checkCgroupRuntimeEnv() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        if ("/".equals(File.separator)) {
            try {
                boolean checkResult = CageSwitch.checkCgroupRuntimeEnv();
                if (checkResult) {
                    cgroupRuntimeEnv = true;
                    switchCfg.put(switchDefaultKey, OFF_STATUS);
                    CageSwitch.registerSwitchStatusListeners();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }
}

