/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.metrics.impl;

import java.io.IOException;
import kd.bos.cage.metrics.ICageEsClient;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

public class CageEsClient
implements ICageEsClient {
    private static final Log logger = LogFactory.getLog(CageEsClient.class);
    private RestHighLevelClient esClient;

    public CageEsClient() {
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig();
        this.buildClient(elasticsearchConfig);
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest, RequestOptions options) {
        try {
            return this.esClient.search(searchRequest, options);
        }
        catch (Exception e) {
            logger.error("cage query metrics error,msg={}", (Object)e.getMessage());
            return new SearchResponse();
        }
    }

    private void buildClient(ElasticsearchConfig config) {
        try {
            String userName = config.getUserName();
            String password = config.getPassword();
            if (userName != null && password != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                this.esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(config.getIp(), config.getPort())}).setHttpClientConfigCallback(arg_0 -> CageEsClient.lambda$buildClient$0((CredentialsProvider)credentialsProvider, arg_0)));
            } else {
                this.esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(config.getIp(), config.getPort(), "http")}));
            }
        }
        catch (Exception e) {
            logger.error("cage init highLevelAccessClient error", (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.esClient != null) {
                this.esClient.close();
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$buildClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

