/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.tenant.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cage.tenant.CageTenant;
import kd.bos.cage.tenant.ICageTenantsConverter;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CageTenantsConverter
implements ICageTenantsConverter {
    private static final Log log = LogFactory.getLog(CageTenantsConverter.class);

    @Override
    public Map<String, CageTenant> generate() {
        HashMap<String, CageTenant> tenantMap = new HashMap<String, CageTenant>(100);
        try {
            CageTenant parent = new CageTenant("kd-cage", null);
            List tenantInfoList = AccountUtils.getAllTenantsByCurrentEnv();
            if (tenantInfoList.isEmpty()) {
                log.info("Cage query all tenants is empty!");
                return tenantMap;
            }
            tenantInfoList.forEach(tenantInfo -> {
                CageTenant tenant = new CageTenant(tenantInfo.getId(), parent);
                tenantMap.put(tenantInfo.getId(), tenant);
            });
        }
        catch (Exception e) {
            log.error("Cage query all tenants error msg={}", (Object)e.getMessage());
        }
        return tenantMap;
    }
}

