/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dtx.dao.AbstractSyncDTXDao;
import kd.bos.dtx.model.ErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SyncErrorDTXDao
extends AbstractSyncDTXDao<ErrorInfo> {
    private static final Log logger = LogFactory.getLog(SyncErrorDTXDao.class);
    protected static final String XID_TABLE = "t_dtx_errors";
    private static final String CREATE_TABLE_SQL = MessageFormat.format("create table {0}(xid varchar(40) not null primary key,error_msg varchar(512),create_time datetime not null,step int not null default 1 )  ", "t_dtx_errors");
    private static final String QUERY_SQL = MessageFormat.format("select xid,create_time,step,error_msg from {0} where xid=? and step=?", "t_dtx_errors");
    private static final String QUERY_SQL_FOR_ID = MessageFormat.format("select xid,create_time,step,error_msg from {0} where xid=? ", "t_dtx_errors");
    private static final String INSERT_SQL = MessageFormat.format("insert into {0}(xid,create_time,error_msg,step) values(?,?,?,?)", "t_dtx_errors");
    private static final String COUNT_SQL = MessageFormat.format("select count(xid) from {0} where xid=? and step=? ", "t_dtx_errors");

    @Override
    public String getTableName() {
        return XID_TABLE;
    }

    @Override
    protected String buildCreateTableSQL() {
        return CREATE_TABLE_SQL;
    }

    @Override
    protected String buildQuerySQL() {
        return QUERY_SQL;
    }

    @Override
    protected String buildQuerySQLForId() {
        return QUERY_SQL_FOR_ID;
    }

    @Override
    protected String buildInsertSQL() {
        return INSERT_SQL;
    }

    @Override
    protected String buildDeleteSQL() {
        return null;
    }

    @Override
    protected String buildCountSQL() {
        return COUNT_SQL;
    }

    @Override
    protected String buildUpdateSQL() {
        return null;
    }

    @Override
    protected Object[] buildInsertParam(ErrorInfo info) {
        return new Object[]{info.getXid(), new Date(), info.getErrorMsg(), info.getStep()};
    }

    @Override
    protected Object[] buildGetParam(ErrorInfo info) {
        return new Object[]{info.getXid(), info.getStep()};
    }

    @Override
    protected Object[] buildGetParam(String id) {
        return null;
    }

    @Override
    protected Object[] buildCountParam(String id) {
        return null;
    }

    @Override
    protected Object[] buildCountParam(ErrorInfo info) {
        return new Object[]{info.getXid(), info.getStep()};
    }

    @Override
    protected Object[] updateParam(ErrorInfo info) {
        return null;
    }

    @Override
    protected Object[] buildDeleteParam(String id) {
        return null;
    }

    @Override
    protected ErrorInfo valueOf(ResultSet rs) throws SQLException {
        if (rs.next()) {
            ErrorInfo info = new ErrorInfo();
            info.setXid(rs.getString("xid"));
            info.setCreateTime(rs.getTimestamp("create_time"));
            info.setErrorMsg(rs.getString("error_msg"));
            info.setStep(rs.getInt("step"));
            return info;
        }
        return null;
    }

    @Override
    protected void checkIndex(String dbKey) {
        if (!DB.exitsIndex((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE, (String)"idx_xid_error")) {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)"create index idx_xid_error on t_dtx_errors(xid) ");
        }
        this.initIndex();
    }

    @Override
    protected void checkTable(String dbKey) {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)XID_TABLE)) {
            this.createTable(dbKey);
        }
        this.initTable(dbKey);
    }
}

