/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.dtx.CompensableOperate;
import kd.bos.dtx.CompensationRule;
import kd.bos.dtx.DTXCompensationService;
import kd.bos.dtx.DTXService;
import kd.bos.dtx.DTXServiceFactory;
import kd.bos.dtx.XidInfo;
import kd.bos.dtx.dao.DTXDao;
import kd.bos.dtx.dao.SyncErrorDTXDao;
import kd.bos.dtx.dao.SyncRetryDTXDao;
import kd.bos.dtx.impl.SimpleCompensationRule;
import kd.bos.dtx.model.ErrorInfo;
import kd.bos.dtx.model.RetryInfo;
import kd.bos.dtx.util.Configuration;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CompensationHandler<R, C extends CompensationRule>
implements DTXCompensationService<R, C> {
    private static final Log log = LogFactory.getLog((String)"CompensationHandler");
    private DTXDao<RetryInfo> dao = new SyncRetryDTXDao();
    private DTXDao<ErrorInfo> errordao = new SyncErrorDTXDao();
    private DTXService dtxService = DTXServiceFactory.getService();

    private String generateXid() {
        return String.valueOf(DB.genLongId((String)this.dao.getTableName()));
    }

    private boolean existTable(String routeKey, String tableName) {
        return DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)tableName);
    }

    private boolean isIgnoreException(Exception ex, CompensableOperate op) {
        List<Class<?>> clss = op.getIgnoreException();
        if (clss != null) {
            for (Class<?> cls : clss) {
                if (!cls.isAssignableFrom(ex.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    private XidInfo getXidInfo(String dbKey, String xid) {
        return this.dtxService.getXid(dbKey, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateTable(String dbKey, DTXDao<?> dtxDao) {
        if (!this.existTable(dbKey, dtxDao.getTableName())) {
            try {
                TX.beginNew();
                dtxDao.createTable(dbKey);
            }
            catch (Exception ex) {
                log.error("create table " + dtxDao.getTableName() + " failed,", (Throwable)ex);
            }
            finally {
                TX.end();
            }
        }
    }

    public static boolean isEmpty(String string) {
        return CompensationHandler.isNull(string) || CompensationHandler.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !CompensationHandler.isEmpty(string);
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !CompensationHandler.isNull(string);
    }

    public static boolean isBlank(String string) {
        return CompensationHandler.isNotNull(string) && string.trim().length() == 0;
    }

    @Override
    public R call(C rule, String xid, String dbKey, CompensableOperate<R> ... ops) {
        if (ops == null || ops.length == 0) {
            throw new KDException("CompensableOperate function is null");
        }
        if (rule == null) {
            throw new KDException("compensationRule is null");
        }
        if (CompensationHandler.isEmpty(dbKey)) {
            throw new KDException("dbKey is null");
        }
        RequestContext rc = RequestContext.get();
        String contextXid = rc.getXid();
        if (CompensationHandler.isEmpty(contextXid)) {
            if (CompensationHandler.isEmpty(xid)) {
                xid = this.dtxService.newXid();
            } else {
                this.dtxService.setXid(xid);
            }
        }
        return this.docall(rule, xid, dbKey, ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R docall(C rule, String xid, String dbKey, CompensableOperate<R> ... ops) {
        Object retryResult = null;
        boolean needRetry = false;
        Exception tex = null;
        ArrayList<CompensableOperate<R>> hasTrylist = new ArrayList<CompensableOperate<R>>();
        CompensableOperate<R> current = null;
        RequestContext rc = RequestContext.get();
        int currentStep = rc.getXidStep();
        for (CompensableOperate<R> op : ops) {
            retryResult = null;
            TX.beginNew();
            try {
                current = op;
                retryResult = current.confirm();
                hasTrylist.add(current);
            }
            catch (Exception ex) {
                tex = ex;
                log.error("try to call first call function error,", (Throwable)ex);
                needRetry = true;
            }
            finally {
                TX.end();
            }
            if (tex != null && this.isIgnoreException(tex, current)) {
                throw new RuntimeException(tex);
            }
            if (!Configuration.isEnable()) {
                needRetry = false;
            }
            if (needRetry) {
                SimpleCompensationRule srule = (SimpleCompensationRule)rule;
                boolean tryfinished = false;
                if (srule.getRetryCount() > 0) {
                    this.checkAndCreateTable(dbKey, this.dao);
                    int triedCount = 0;
                    this.dao.count(xid, dbKey);
                    while (triedCount < srule.getRetryCount()) {
                        try {
                            TX.beginNew();
                            try {
                                log.debug("try " + ++triedCount + " times to recall function");
                                this.dao.insert(new RetryInfo(this.generateXid(), xid, currentStep), dbKey);
                            }
                            catch (Exception ie) {
                                log.error((Throwable)ie);
                                TX.markRollback();
                                throw ie;
                            }
                            finally {
                                TX.end();
                            }
                            TX.beginNew();
                            try {
                                R result = current.confirm();
                                retryResult = result;
                                hasTrylist.add(current);
                            }
                            catch (Exception ex) {
                                log.error((Throwable)ex);
                                TX.markRollback();
                                throw ex;
                            }
                            finally {
                                TX.end();
                            }
                        }
                        catch (Exception e) {
                            log.error((Throwable)e);
                            tex = e;
                        }
                        if (retryResult == null) {
                            if (tex != null && this.isIgnoreException(tex, current)) {
                                throw new RuntimeException(tex);
                            }
                            if (triedCount < srule.getRetryCount()) continue;
                            tryfinished = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    tryfinished = true;
                }
                if (tryfinished && srule.isCanCancel()) {
                    log.warn(current.operateName() + " operate try to cancel");
                    this.doCancel(current, hasTrylist, dbKey);
                    break;
                }
            }
            if (retryResult == null && tex != null) {
                throw new RuntimeException(tex);
            }
            rc.setXidStep(++currentStep);
        }
        return retryResult;
    }

    private void doCancel(CompensableOperate<R> current, List<CompensableOperate<R>> hasTrylist, String dbKey) {
        this.doCancel(current, dbKey);
        if (hasTrylist.size() > 0) {
            for (int i = hasTrylist.size() - 1; i >= 0; --i) {
                CompensableOperate<R> before = hasTrylist.get(i);
                this.doCancel(before, dbKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel(CompensableOperate<R> operate, String dbKey) {
        try {
            operate.cancel();
        }
        catch (Exception e) {
            log.error("try to call cancel function error,", (Throwable)e);
            this.doFinalwork(operate, dbKey);
        }
        finally {
            RequestContext rc = RequestContext.get();
            rc.setXidStep(rc.getXidStep() - 1);
        }
    }

    private void doFinalwork(CompensableOperate<R> operate, String dbKey) {
        String cancelFailedLog = null;
        RequestContext rc = RequestContext.get();
        try {
            cancelFailedLog = operate.finalwork();
            StringBuilder builder = new StringBuilder();
            builder.append(cancelFailedLog);
            ErrorInfo info = new ErrorInfo();
            info.setXid(rc.getXid());
            info.setStep(rc.getXidStep());
            info.setErrorMsg(cancelFailedLog);
            this.recordError(info, dbKey);
        }
        catch (Exception ex) {
            log.error("try to call finalwork function error,", (Throwable)ex);
        }
    }

    private void recordError(ErrorInfo info, String dbKey) {
        this.checkAndCreateTable(dbKey, this.errordao);
        TX.beginNew();
        try {
            this.errordao.insert(info, dbKey);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            TX.markRollback();
            throw ex;
        }
        finally {
            TX.end();
        }
    }
}

