/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dtx.util;

import kd.bos.util.ConfigurationChangeListener;

public class Configuration
implements ConfigurationChangeListener {
    private static String DEFAULT_SERVICE = "kd.bos.dtx.impl.SyncDTXService";
    private static String DEFAULT_CLEANER = "kd.bos.dtx.schedule.impl.SyncDTXCleaner";
    private static boolean enableXid = false;
    private static String SERVICE_CLASS = null;
    private static String CLEANER_CLASS = null;
    private static final String ENABLE_XID = "enable.xid";
    private static final String DTX_SERVICE_CLASS = "dtx.class";
    private static final String DTX_CLEANER_CLASS = "dtx.cleaner.class";
    private static String ENABLE_XID_VALUE = null;
    private static String DTX_SERVICE_CLASS_VALUE = null;
    private static String DTX_CLEANER_CLASS_VALUE = null;

    public void onChange(Object arg0, Object arg1) {
        String newclass;
        String newenable = System.getProperty(ENABLE_XID);
        if (newenable != null && !newenable.equals(ENABLE_XID_VALUE)) {
            Configuration.setEnableXidValue(newenable);
        }
        if ((newclass = System.getProperty(DTX_SERVICE_CLASS)) != null && !newclass.equals(DTX_SERVICE_CLASS_VALUE)) {
            Configuration.setDTXServiceClassValue(newclass);
        }
    }

    private static void setDTXServiceClassValue(String newStr) {
        DTX_SERVICE_CLASS_VALUE = newStr;
    }

    private static void setEnableXidValue(String newStr) {
        ENABLE_XID_VALUE = newStr;
    }

    private static void fireChange() {
        boolean bl = enableXid = "1".equals(ENABLE_XID_VALUE);
        if (DTX_SERVICE_CLASS_VALUE == null) {
            DTX_SERVICE_CLASS_VALUE = DEFAULT_SERVICE;
        }
        if (DTX_CLEANER_CLASS_VALUE == null) {
            DTX_CLEANER_CLASS_VALUE = DEFAULT_CLEANER;
        }
        SERVICE_CLASS = DTX_SERVICE_CLASS_VALUE;
        CLEANER_CLASS = DTX_CLEANER_CLASS_VALUE;
    }

    public static boolean isEnable() {
        return enableXid;
    }

    public static String getServiceClass() {
        return SERVICE_CLASS;
    }

    public static String getCleanerClass() {
        return CLEANER_CLASS;
    }

    public static String getCompensationServiceClass() {
        return "kd.bos.dtx.impl.CompensationHandler";
    }

    static {
        ENABLE_XID_VALUE = System.getProperty(ENABLE_XID);
        DTX_SERVICE_CLASS_VALUE = System.getProperty(DTX_SERVICE_CLASS);
        DTX_CLEANER_CLASS_VALUE = System.getProperty(DTX_CLEANER_CLASS);
        Configuration.fireChange();
    }
}

