/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.config;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.config.RegionDef;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.MQConfig;
import kd.bos.mq.support.partition.QueueMetaManager;
import kd.bos.util.StringUtils;

@XmlRootElement(name="root")
public class UsageConfig {
    private static final String UTF_8 = "UTF-8";
    private static Log log = LogFactory.getLog(UsageConfig.class);
    private List<RegionDef> regions;
    private static List<RegionDef> injectedRegions;

    public static UsageConfig get() {
        String xinghanXml;
        String boxXml;
        block53: {
            UsageConfig.initPluginConfig();
            boxXml = null;
            try (InputStream in = UsageConfig.class.getResourceAsStream("/kd/bos/mq/bos_mqqueueconfig.xml");){
                boxXml = StringUtils.fromInputStream((InputStream)in, (String)UTF_8);
            }
            catch (IOException e) {
                log.error("Can't load /kd/bos/mq/bos_mqqueueconfig.xml", (Throwable)e);
                System.exit(-1);
            }
            xinghanXml = null;
            String xinghanXmlFileName = "/kd/xinghan/mqqueueconfig.xml";
            try (InputStream in = UsageConfig.class.getResourceAsStream(xinghanXmlFileName);){
                if (in == null) {
                    xinghanXmlFileName = "/kd/bos/mq/xinghan_mqqueueconfig.xml";
                    try (InputStream in2 = UsageConfig.class.getResourceAsStream(xinghanXmlFileName);){
                        xinghanXml = StringUtils.fromInputStream((InputStream)in2, (String)UTF_8);
                        break block53;
                    }
                }
                xinghanXml = StringUtils.fromInputStream((InputStream)in, (String)UTF_8);
            }
            catch (IOException e) {
                log.error("Can't load " + xinghanXmlFileName, (Throwable)e);
                System.exit(-1);
            }
        }
        if (boxXml == null || xinghanXml == null) {
            return null;
        }
        UsageConfig base = UsageConfig.parse(boxXml);
        UsageConfig xinghanBase = UsageConfig.parse(xinghanXml);
        xinghanBase.getRegions().forEach(base::mergeRegion);
        try {
            UsageConfig.mergeInjectedRegions(base);
        }
        catch (Exception e) {
            log.error("inject regions config error", (Throwable)e);
        }
        try {
            UsageConfig.loadProductLineMqConfigFiles(base);
        }
        catch (Exception e) {
            log.error("load loadAppConifgFiles.confg error", (Throwable)e);
        }
        try {
            UsageConfig.loadAppConifgFiles(base);
        }
        catch (Exception e) {
            log.error("load loadAppConifgFiles.confg error", (Throwable)e);
        }
        try {
            UsageConfig.loadMqConfigFiles(base);
        }
        catch (Exception e) {
            log.error("load loadMqConfigFiles.confg error", (Throwable)e);
        }
        try {
            UsageConfig.loadDynamicConfig(base);
        }
        catch (Exception e) {
            log.error("load dynamic queue from zk fail", (Throwable)e);
        }
        return base;
    }

    private static void loadAppConifgFiles(UsageConfig base) throws IOException {
        String xml = null;
        try {
            Class.forName("kd.bos.web.DispatchServiceHelper");
        }
        catch (Exception e) {
            log.error("class for DispatchServiceHelper exception", (Throwable)e);
        }
        String[] appIds = UsageConfig.getAppIds();
        if (appIds != null) {
            for (String appid : appIds) {
                try (InputStream in = UsageConfig.class.getResourceAsStream("/" + appid + "/mqbizconfig.xml");){
                    if (in == null) continue;
                    try {
                        xml = StringUtils.fromInputStream((InputStream)in, (String)UTF_8);
                        UsageConfig biz = UsageConfig.parse(xml);
                        if (biz.regions == null || biz.regions.size() <= 0) continue;
                        biz.regions.forEach(r -> base.mergeRegion((RegionDef)r));
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
            }
        }
    }

    private static void loadProductLineMqConfigFiles(UsageConfig base) throws IOException {
        String mqConfigFile;
        String xml = null;
        String configActionFiles = System.getProperty("productline.mqConfigFiles.config");
        if (configActionFiles == null) {
            return;
        }
        boolean replacestandardFlag = Boolean.getBoolean("mq.congig.canreplacestandard.enable");
        if (!replacestandardFlag) {
            System.setProperty("mq.congig.canreplacestandard.enable", "true");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(configActionFiles.getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((mqConfigFile = br.readLine()) != null) {
            if (mqConfigFile.trim().endsWith(".xml")) {
                if (!(mqConfigFile = mqConfigFile.substring(0, mqConfigFile.length() - 4).replaceAll("\\.", "/") + ".xml").startsWith("/")) {
                    mqConfigFile = "/" + mqConfigFile;
                }
                InputStream in = UsageConfig.class.getResourceAsStream(mqConfigFile);
                Throwable throwable = null;
                try {
                    if (in == null) continue;
                    try {
                        xml = StringUtils.fromInputStream((InputStream)in, (String)UTF_8);
                        UsageConfig biz = UsageConfig.parse(xml);
                        if (biz.regions == null || biz.regions.size() <= 0) continue;
                        biz.regions.forEach(base::mergeRegion);
                    }
                    catch (IOException e) {
                        log.error("Can't load file :" + mqConfigFile, (Throwable)e);
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                    continue;
                }
            }
            log.error("mq config error ,which not end with .xml:\u3000" + mqConfigFile);
        }
        if (!replacestandardFlag) {
            System.clearProperty("mq.congig.canreplacestandard.enable");
        }
    }

    private static void loadMqConfigFiles(UsageConfig base) throws IOException {
        String xml = null;
        String configActionFiles = System.getProperty("mqConfigFiles.config");
        if (configActionFiles != null && configActionFiles.trim().length() > 0) {
            String mqConfigFile;
            ByteArrayInputStream is = new ByteArrayInputStream(configActionFiles.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((mqConfigFile = br.readLine()) != null) {
                if (mqConfigFile.trim().endsWith(".xml")) {
                    if (!(mqConfigFile = mqConfigFile.substring(0, mqConfigFile.length() - 4).replaceAll("\\.", "/") + ".xml").startsWith("/")) {
                        mqConfigFile = "/" + mqConfigFile;
                    }
                    InputStream in = UsageConfig.class.getResourceAsStream(mqConfigFile);
                    Throwable throwable = null;
                    try {
                        if (in == null) continue;
                        try {
                            xml = StringUtils.fromInputStream((InputStream)in, (String)UTF_8);
                            UsageConfig biz = UsageConfig.parse(xml);
                            if (biz.regions == null || biz.regions.size() <= 0) continue;
                            for (RegionDef tempRegionDef : biz.regions) {
                                base.mergeRegion(tempRegionDef);
                            }
                            continue;
                        }
                        catch (IOException e) {
                            log.error("Can't load file :" + mqConfigFile, (Throwable)e);
                            continue;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                        continue;
                    }
                }
                log.error("mq config error ,which not end with .xml:\u3000" + mqConfigFile);
            }
        }
    }

    private static String[] getAppIds() {
        Set idSet = new HashSet();
        try {
            Class<?> testClass = Class.forName("kd.bos.service.lookup.ServiceLookup");
            Method m = testClass.getMethod("getSystemAppIds", new Class[0]);
            idSet = (Set)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.warn("getSystemAppIds exception ", (Throwable)e);
        }
        return idSet.toArray(new String[0]);
    }

    private static UsageConfig parse(String xml) {
        return UsageConfig.parse(new StringReader(xml));
    }

    private static UsageConfig parse(Reader reader) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{UsageConfig.class});
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(reader);
            Unmarshaller un = jaxbContext.createUnmarshaller();
            UsageConfig usageConfig = (UsageConfig)un.unmarshal(xsr);
            return usageConfig;
        }
        catch (Exception t) {
            throw new KDException(BosErrorCode.mqServerConfiguration, "mq usage config parse error", (Throwable)t);
        }
    }

    public static void main(String[] args) {
    }

    @XmlElements(value={@XmlElement(name="region", type=RegionDef.class)})
    public List<RegionDef> getRegions() {
        return this.regions;
    }

    public void setRegions(List<RegionDef> regions) {
        this.regions = regions;
    }

    private void mergeRegion(RegionDef regionDef) {
        if (regionDef == null || regionDef.getQueues() == null) {
            return;
        }
        boolean existRegion = false;
        for (RegionDef region : this.regions) {
            if (!region.getName().equals(regionDef.getName())) continue;
            existRegion = true;
            List<QueueDef> queuesLs = region.getQueues();
            HashMap queuesMap = new HashMap();
            queuesLs.forEach(v -> queuesMap.put(v.getName(), v));
            regionDef.getQueues().forEach(v -> {
                if (queuesMap.containsKey(v.getName())) {
                    if (Boolean.getBoolean("mq.congig.canreplacestandard.enable")) {
                        queuesLs.remove(queuesMap.get(v.getName()));
                        queuesLs.add((QueueDef)v);
                    }
                } else {
                    queuesLs.add((QueueDef)v);
                }
            });
            break;
        }
        if (!existRegion) {
            this.regions.add(regionDef);
        }
    }

    private static void mergeInjectedRegions(UsageConfig base) {
        if (injectedRegions != null && !injectedRegions.isEmpty()) {
            injectedRegions.forEach(base::mergeRegion);
            log.info("the config loaded from plugins : {}", (Object)JSON.toJSONString(injectedRegions));
        }
    }

    private static void injectRegions(String regionsXml) throws KDException {
        if (StringUtils.isNotEmpty((String)regionsXml)) {
            UsageConfig injectConfig = UsageConfig.parse(regionsXml);
            if (injectedRegions == null) {
                injectedRegions = new ArrayList<RegionDef>();
            }
            injectedRegions.addAll(injectConfig.regions);
        }
    }

    private static void initPluginConfig() {
        try {
            Map classes = ExtensionFactory.getExtensionFacotry(MQConfig.class).getExtensionClasses();
            for (Class cls : classes.values()) {
                String xml = null;
                try {
                    MQConfig mqConfig = (MQConfig)cls.newInstance();
                    xml = mqConfig.generateConfig();
                    UsageConfig.injectRegions(xml);
                }
                catch (Exception e) {
                    log.error("init  register Mq config  plugin [{}] fail: generateConfig= {}", new Object[]{cls.getName(), xml, e});
                }
            }
        }
        catch (Exception e) {
            log.error("init PluginConfig fail", (Throwable)e);
        }
    }

    private static void loadDynamicConfig(UsageConfig base) {
        Map<String, List<QueueDef>> cache = UsageConfig.loadFromMC(base);
        if (cache != null && cache.size() > 0) {
            base.getRegions().forEach(regionDef -> {
                if (cache.containsKey(regionDef.getName())) {
                    regionDef.getQueues().addAll((Collection)cache.get(regionDef.getName()));
                }
            });
        }
    }

    private static Map<String, List<QueueDef>> loadFromMC(UsageConfig base) {
        Object rs;
        HashMap<String, List<QueueDef>> cache = new HashMap<String, List<QueueDef>>();
        if (base != null && !base.getRegions().isEmpty() && (rs = QueueMetaManager.getQueueMeta("")) instanceof List) {
            List queueMetas = (List)rs;
            for (Object queueMeta : queueMetas) {
                String[] split = ((String)queueMeta).split("@#");
                if (split.length != 3) continue;
                String region = split[0];
                String queueName = split[1];
                String appId = split[2];
                base.getRegions().forEach(baseRegion -> {
                    if (baseRegion.getName().equals(region)) {
                        baseRegion.getQueues().forEach(queueDef -> {
                            if (queueDef.getName().equals(queueName)) {
                                QueueDef defDynamic = QueueManager.redefineQueueDef(queueDef, appId, queueName + "." + appId);
                                List list = (List)cache.get(baseRegion.getName());
                                if (list == null) {
                                    ArrayList<QueueDef> dynamicQueues = new ArrayList<QueueDef>();
                                    dynamicQueues.add(defDynamic);
                                    cache.put(baseRegion.getName(), dynamicQueues);
                                } else {
                                    list.add(defDynamic);
                                }
                            }
                        });
                    }
                });
            }
        }
        return cache;
    }
}

