/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.delay;

import java.util.Calendar;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.support.Message;

public class DelayControlManager {
    public static final int[] supportMetaTime = new int[]{1, 5, 10, 30, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 1200, 1800, 3600, 7200};
    private static final int SUPPORT_META_TIME_MIN_LEVEL = 1;
    private static final String SUPPORT_MIN_SECOND = "mq.delay.min.second";
    private static final String SUPPORT_MAX_SECOND = "mq.delay.max.second";

    public static void installDelayInfo(Message message, int seconds) {
        int minDelayTime = Integer.getInteger(SUPPORT_MIN_SECOND, 5);
        if (seconds >= minDelayTime) {
            DelayControlManager.validateTime(seconds);
            message.setStartDeliverTime(DelayControlManager.convertTime(seconds));
        }
    }

    private static void validateTime(int seconds) {
        int maxDelayTime = Integer.getInteger(SUPPORT_MAX_SECOND, 7200);
        if (seconds > maxDelayTime) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"max delay time is " + maxDelayTime + " seconds"});
        }
    }

    public static MetaTime selectMaxMetaTime(int remainSeconds) {
        MetaTime metaTime;
        int level = -1;
        for (int i = supportMetaTime.length - 1; i >= 0; --i) {
            if (supportMetaTime[i] > remainSeconds) continue;
            level = i + 1;
            break;
        }
        return (metaTime = MetaTime.genInstanceByLevel(level)) == null ? MetaTime.delay_1s : metaTime;
    }

    public static long convertTime(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, seconds);
        return calendar.getTime().getTime();
    }
}

