/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.delay;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.delay.MetaTime;

public class RabbitMQDelayManager {
    private static final String DELAY_EXCHANGE = "delayQueueExchange";
    private static final String DEAD_LETTER_EXCHANGE = "dlxExchange";
    private static final String TTL_QUEUE_SUFFIX = "_ttlQueue";
    private static final String DELAY_EXCHANGE_BINDING_KEY_SUFFIX = ".#";
    private static final String DEAD_LETTER_EXCHANGE_BINDING_KEY_PREFIX = "*.";
    private static final String PUBLISH_ROUTE_KEY_SEPARATOR = ".";
    private static Set<String> preDealCache = new HashSet<String>();

    private static void initDelayAndDeadLetterExchange(Channel channel) throws IOException {
        channel.exchangeDeclare(DELAY_EXCHANGE, BuiltinExchangeType.TOPIC, true, false, null);
        channel.exchangeDeclare(DEAD_LETTER_EXCHANGE, BuiltinExchangeType.TOPIC, true, false, null);
    }

    private static void initTTLQueue(Channel channel, MetaTime metaTime) throws IOException {
        HashMap<String, Object> ttlQueueArg = new HashMap<String, Object>();
        ttlQueueArg.put("x-message-ttl", metaTime.getMillis());
        ttlQueueArg.put("x-dead-letter-exchange", DEAD_LETTER_EXCHANGE);
        ttlQueueArg.put("x-max-length", 1000000);
        channel.queueDeclare(metaTime.getName() + TTL_QUEUE_SUFFIX, true, false, false, ttlQueueArg);
        channel.queueBind(metaTime.getName() + TTL_QUEUE_SUFFIX, DELAY_EXCHANGE, metaTime.getName() + DELAY_EXCHANGE_BINDING_KEY_SUFFIX);
    }

    private static void dlxBindTargetQueue(Channel channel, String targetQueue) throws IOException {
        channel.queueBind(targetQueue, DEAD_LETTER_EXCHANGE, DEAD_LETTER_EXCHANGE_BINDING_KEY_PREFIX + targetQueue);
    }

    private static void delayMessagePreDeal(Channel channel, String targetQueue, MetaTime metaTime) throws IOException {
        String cacheKey = metaTime.getName() + targetQueue;
        if (preDealCache.add(cacheKey)) {
            RabbitMQDelayManager.initDelayAndDeadLetterExchange(channel);
            RabbitMQDelayManager.initTTLQueue(channel, metaTime);
            RabbitMQDelayManager.dlxBindTargetQueue(channel, targetQueue);
        }
    }

    private static String assembleRoutingKey(String targetQueue, MetaTime metaTime) {
        return metaTime.getName() + PUBLISH_ROUTE_KEY_SEPARATOR + targetQueue;
    }

    public static void publishDelayMessage(byte[] bytes, Channel channel, String targetQueue, MetaTime metaTime) throws IOException {
        RabbitMQDelayManager.delayMessagePreDeal(channel, targetQueue, metaTime);
        AMQP.BasicProperties p = new AMQP.BasicProperties().builder().deliveryMode(Integer.valueOf(2)).build();
        String routingKey = RabbitMQDelayManager.assembleRoutingKey(targetQueue, metaTime);
        channel.basicPublish(DELAY_EXCHANGE, routingKey, p, bytes);
    }

    public static void publishDelayMessageConfirmModel(byte[] bytes, Channel channel, String targetQueue, MetaTime metaTime) throws IOException, TimeoutException, InterruptedException {
        RabbitMQDelayManager.delayMessagePreDeal(channel, targetQueue, metaTime);
        AMQP.BasicProperties p = new AMQP.BasicProperties().builder().deliveryMode(Integer.valueOf(2)).build();
        String routingKey = RabbitMQDelayManager.assembleRoutingKey(targetQueue, metaTime);
        channel.confirmSelect();
        channel.basicPublish(DELAY_EXCHANGE, routingKey, p, bytes);
        if (!channel.waitForConfirms(Long.getLong("mq.publish.confirm.timeout", 60000L).longValue())) {
            throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"publish fail: wait for confirm timeout"});
        }
    }
}

