/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.dlx;

import kd.bos.mq.dlx.DLXProducer;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.support.MessageSerde;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class DLXRocketDLXProducer
implements DLXProducer {
    private DefaultMQProducer producer;
    private String vhost;
    private String queueName;

    public DLXRocketDLXProducer(DefaultMQProducer producer, String vhost, String queueName) {
        this.producer = producer;
        this.vhost = vhost;
        this.queueName = queueName;
    }

    @Override
    public void send(kd.bos.mq.support.Message message) {
        byte[] bytes = MessageSerde.get().encode(message);
        try {
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName(this.vhost, this.queueName);
            Message rocketMessage = new Message(groupAndTopicName, "*", bytes);
            this.producer.send(rocketMessage);
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            ExceptionLogger.warn("migrate message fail,the message has been saved in the database");
        }
    }

    public void close() {
        this.producer.shutdown();
    }
}

