/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.dlx;

import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.mq.dlx.DLXConfig;

public class MessageRecord {
    private static final String INSERT_SQL = "insert into t_dlx_message(fid,fstatus,fcreatetime,fupdatetime,fmessage,fregion,fqueue) values(?,?,?,?,?,?,?)";
    private static final String EXIST_SQL = "select fid,fcount from t_dlx_message where fid = ?";
    private static final String UPDATE_COUNT_SQL = "update t_dlx_message set fupdatetime = ?,fcount = ? where fid = ?";
    private static final String UPDATE_SQL = "update t_dlx_message set fstatus = ?,fupdatetime = ? where fid = ?";

    public static int insert(long fid, byte[] body, String region, String queueName) {
        Date date = new Date();
        int errorCount = (Integer)DB.query((DBRoute)DBRoute.basedata, (String)EXIST_SQL, (Object[])new Object[]{fid}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("fcount");
            }
            return 0;
        });
        if (errorCount >= DLXConfig.SEND_ERROR_COUNT) {
            return errorCount;
        }
        if (errorCount > 0) {
            DB.execute((DBRoute)DBRoute.basedata, (String)UPDATE_COUNT_SQL, (Object[])new Object[]{date, ++errorCount, fid});
        } else {
            DB.execute((DBRoute)DBRoute.basedata, (String)INSERT_SQL, (Object[])new Object[]{fid, 0, date, date, body, region, queueName});
        }
        return errorCount;
    }

    public static boolean onlyInsert(long fid, byte[] body, String region, String queueName) {
        Date date = new Date();
        return DB.execute((DBRoute)DBRoute.basedata, (String)INSERT_SQL, (Object[])new Object[]{fid, 0, date, date, body, region, queueName});
    }

    public static boolean update(int status, long fid) {
        return DB.execute((DBRoute)DBRoute.basedata, (String)UPDATE_SQL, (Object[])new Object[]{status, new Date(), fid});
    }
}

