/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover;

import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.failover.FailoverBroadcastUtil;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.failover.FailoverMessageCount;
import kd.bos.mq.failover.FailoverQueueManager;

public class FailoverPublisherWrapper
implements MessagePublisher {
    private static final Log LOGGER = LogFactory.getLog(FailoverPublisherWrapper.class);
    private static ExtensionFactory<FailoverMessageCount> messageCountExtensionFactory = ExtensionFactory.getExtensionFacotry(FailoverMessageCount.class);
    private String region;
    private String queueRealName;
    private MessagePublisher originPublisher;
    private MessagePublisher failoverPublisher;

    public FailoverPublisherWrapper(String region, String queueRealName, MessagePublisher originPublisher, MessagePublisher failoverPublisher) {
        this.region = region;
        this.queueRealName = queueRealName;
        this.originPublisher = originPublisher;
        this.failoverPublisher = failoverPublisher;
    }

    private void beforePublish() {
        if (!FailoverQueueManager.containsQueueName(this.queueRealName)) {
            FailoverQueueManager.registerQueueName(this.region, this.queueRealName);
        }
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            int count = ((FailoverMessageCount)messageCountExtensionFactory.getExtension(FailoverConfig.getMQType(this.region))).count(this.region, this.queueRealName);
            if (count == 0) {
                FailoverQueueManager.markMoveSuccess(this.queueRealName);
                FailoverBroadcastUtil.markMoveSuccess(this.queueRealName);
            } else {
                LOGGER.info("failoverCount is not zero,region:{},queueRealName:{},maybe not deploy consumer", (Object)this.region, (Object)this.queueRealName);
            }
        }
    }

    @Override
    public void publish(byte[] message) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publish(message);
        } else {
            this.originPublisher.publish(message);
        }
    }

    @Override
    public void publish(String message) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publish(message);
        } else {
            this.originPublisher.publish(message);
        }
    }

    @Override
    public void publish(Object message) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publish(message);
        } else {
            this.originPublisher.publish(message);
        }
    }

    @Override
    public void publish(Object message, String partitionKey) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publish(message, partitionKey);
        } else {
            this.originPublisher.publish(message, partitionKey);
        }
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publishInDbTranscation(routKey, message);
        } else {
            this.originPublisher.publishInDbTranscation(routKey, message);
        }
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message, String partitionKey) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publishInDbTranscation(routKey, message, partitionKey);
        } else {
            this.originPublisher.publishInDbTranscation(routKey, message, partitionKey);
        }
    }

    @Override
    public void publishDelay(Object message, int seconds) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publishDelay(message, seconds);
        } else {
            this.originPublisher.publishDelay(message, seconds);
        }
    }

    @Override
    public void publishDelay(Object message, int seconds, String partitionKey) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publishDelay(message, seconds, partitionKey);
        } else {
            this.originPublisher.publishDelay(message, seconds, partitionKey);
        }
    }

    @Override
    public void $$publishConfirm(byte[] message) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.$$publishConfirm(message);
        } else {
            this.originPublisher.$$publishConfirm(message);
        }
    }

    @Override
    public void publishInDbTranscation(Object message) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publishInDbTranscation(message);
        } else {
            this.originPublisher.publishInDbTranscation(message);
        }
    }

    @Override
    public void publishDelayInDbTranscation(Object message, int seconds) {
        this.beforePublish();
        if (!FailoverQueueManager.isMoveStatusSuccess(this.queueRealName)) {
            this.failoverPublisher.publishDelayInDbTranscation(message, seconds);
        } else {
            this.originPublisher.publishDelayInDbTranscation(message, seconds);
        }
    }

    @Override
    public void close() {
        this.originPublisher.close();
        this.failoverPublisher.close();
    }

    public MessagePublisher getOriginPublisher() {
        return this.originPublisher;
    }
}

