/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FailoverQueueManager {
    private static final Map<String, String> queueRealName2moveStatusMap = new ConcurrentHashMap<String, String>();

    public static void registerQueueName(String region, String queueRealName) {
        if (region.equals("demo")) {
            return;
        }
        queueRealName2moveStatusMap.putIfAbsent(queueRealName, "READY");
    }

    public static boolean containsQueueName(String queueRealName) {
        return queueRealName2moveStatusMap.containsKey(queueRealName);
    }

    public static boolean isMoveStatusSuccess(String queueRealName) {
        return queueRealName2moveStatusMap.get(queueRealName).equals("SUCCESS");
    }

    public static void markMoveRunning(String queueRealName) {
        queueRealName2moveStatusMap.put(queueRealName, "RUNNING");
    }

    public static void markMoveSuccess(String queueRealName) {
        queueRealName2moveStatusMap.put(queueRealName, "SUCCESS");
    }

    public static Map<String, String> copyMoveSuccessMap() {
        return new HashMap<String, String>(queueRealName2moveStatusMap);
    }
}

