/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover.rabbit;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.failover.FailoverMoveTask;
import kd.bos.mq.failover.FailoverPublisherWrapper;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.rabbitmq.RabbitmqFactory;

public class RabbitFailoverMoveTask
implements FailoverMoveTask {
    private static final Log LOGGER = LogFactory.getLog(RabbitFailoverMoveTask.class);
    private String region;
    private String queueRealName;
    private MessagePublisher originPublisher;
    private Channel channel;
    private List<Long> deliveryTagList;

    @Override
    public void init(String region, String queueRealName) {
        this.region = region;
        this.queueRealName = queueRealName;
        FailoverPublisherWrapper failoverPublisherWrapper = (FailoverPublisherWrapper)MQFactory.get().$createPublisherWithRealQueueName(region, queueRealName);
        this.originPublisher = failoverPublisherWrapper.getOriginPublisher();
    }

    @Override
    public List<Message> getBatchMessageList() {
        ArrayList<Message> allMessageList = new ArrayList<Message>(100);
        String failoverServerKey = FailoverConfig.getFailoverServerKey(this.region);
        try {
            GetResponse response;
            Connection connection = RabbitmqFactory.getConnection((String)failoverServerKey);
            this.channel = connection.createChannel();
            this.channel.basicQos(10);
            this.deliveryTagList = new ArrayList<Long>(100);
            for (int i = 0; i < 100000 && (response = this.channel.basicGet(this.queueRealName, false)) != null; ++i) {
                byte[] body = response.getBody();
                Message message = MessageSerde.get().decode(body);
                allMessageList.add(message);
                long deliveryTag = response.getEnvelope().getDeliveryTag();
                this.deliveryTagList.add(deliveryTag);
            }
        }
        catch (Exception e) {
            LOGGER.error("getBatchMessageList error", (Throwable)e);
        }
        return allMessageList;
    }

    @Override
    public void move(List<Message> messageList) {
        RequestContext oldCtx = RequestContext.get();
        for (Message tempMessage : messageList) {
            PigeonRequestContextUtil.set((RequestContext)tempMessage.getRequestContext());
            byte[] bytes = MessageSerde.get().encode(tempMessage);
            this.originPublisher.$$publishConfirm(bytes);
        }
        if (oldCtx == null) {
            RequestContext.set(null);
        } else {
            PigeonRequestContextUtil.set((RequestContext)oldCtx);
        }
    }

    @Override
    public void afterMove() {
        try {
            if (this.channel != null) {
                for (Long tempTag : this.deliveryTagList) {
                    this.channel.basicAck(tempTag.longValue(), false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.deliveryTagList = null;
    }

    @Override
    public void recycleResource() {
        if (this.originPublisher != null) {
            this.originPublisher.close();
        }
    }
}

