/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.init;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.instance.AppGroup;
import kd.bos.instance.MainGroupChangeListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.config.RegionDef;
import kd.bos.mq.config.UsageConfig;
import kd.bos.mq.init.MQAppGroupListener;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.RabbitConsumer;
import kd.bos.mq.support.ConfigForInitConsumer;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.QueueMetaManager;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;

public class MQInit {
    private static final Log logger = LogFactory.getLog((String)"stdot");
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private static final Map<String, String> deployConfig = new HashMap<String, String>(8);
    private static final String CHECK_CONNECTED = "check connected";
    private static final String MQ_CHECK_CONNECTION_ENABLE = "mq.check.connection.enable";
    private static final String DEMO_REGION = "demo";
    private static final String DEMO_QUEUE = "demo_queue";
    private static Map<String, Map<String, String>> sequentialQueueMap = new ConcurrentHashMap<String, Map<String, String>>(8);

    public static void init() {
        UsageConfig config = UsageConfig.get();
        if (config == null || config.getRegions() == null) {
            return;
        }
        MQInit.initConfigQueueDeploy();
        MQInit.checkConnected(config);
        for (RegionDef region : config.getRegions()) {
            try {
                MQInit.initRegion(region);
            }
            catch (Exception t) {
                logger.error("init mq for region " + region + " error", (Throwable)t);
            }
        }
        BroadcastService.start();
        MQInit.initSequentialQueueElect();
        AppGroup.registGroupListener((MainGroupChangeListener)new MQAppGroupListener());
        inited.set(true);
        QueueMetaManager.startQueueMetaManage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkConnected(UsageConfig config) {
        block11: {
            String isMCString = SystemProperties.getWithEnv((String)"isMC");
            if ("true".equalsIgnoreCase(isMCString)) {
                return;
            }
            MQInit.initCheckConnectionQueue(config);
            RequestContext requestContextCurrent = RequestContext.get();
            try {
                boolean check;
                MQInit.createTempMqRequestContext();
                String mqType = QueueManager.getMQType(DEMO_REGION);
                boolean bl = check = Boolean.parseBoolean(System.getProperty(MQ_CHECK_CONNECTION_ENABLE, "true")) && mqType != null && !mqType.equals("pigeon");
                if (!check || ConfigForInitConsumer.isNotInitConsumer()) break block11;
                int maxRetries = Integer.getInteger("mq.check.connection.max", 30);
                int retryCount = 0;
                boolean connected = false;
                while (retryCount < maxRetries && !connected) {
                    MessagePublisher publisher = null;
                    try {
                        publisher = MQFactory.get().createSimplePublisher(DEMO_REGION, DEMO_QUEUE);
                        publisher.publish(CHECK_CONNECTED);
                        connected = true;
                    }
                    catch (Exception e) {
                        LockSupport.parkNanos(1000000000L);
                        logger.error("MQ service connection failed {} times! Up to {} times will shutdown down\uff1a", new Object[]{++retryCount, maxRetries, e});
                    }
                    finally {
                        if (publisher == null) continue;
                        publisher.close();
                    }
                }
                if (!connected) {
                    logger.error("MQ service checkConnected fail , will shutdown now.");
                    LockSupport.parkNanos(2000000000L);
                    System.exit(-1);
                }
            }
            finally {
                RequestContext.set((RequestContext)requestContextCurrent);
            }
        }
    }

    private static void initCheckConnectionQueue(UsageConfig config) {
        block0: for (RegionDef region : config.getRegions()) {
            if (!DEMO_REGION.equals(region.getName())) continue;
            for (QueueDef queue : region.getQueues()) {
                if (!DEMO_QUEUE.equals(queue.getName())) continue;
                QueueManager.add(region.getName(), queue, false);
                break block0;
            }
        }
    }

    private static void createTempMqRequestContext() {
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setUserAgent("MQ");
    }

    public static void waitForMQFinishInit(String region) {
        while (!DEMO_REGION.equals(region) && !inited.get()) {
            LockSupport.parkNanos(100000000L);
        }
    }

    private static void initRegion(RegionDef region) {
        String name = region.getName();
        if (region.getQueues() == null) {
            return;
        }
        StringBuilder logStringBuilder = new StringBuilder();
        String regionAppid = region.getAppid();
        for (QueueDef queue : region.getQueues()) {
            try {
                String value;
                String queueAppid = queue.getAppid();
                if (queueAppid == null && regionAppid != null) {
                    queue.setAppid(regionAppid);
                    queueAppid = regionAppid;
                }
                if (StringUtils.isNotEmpty((String)(value = deployConfig.get(name + "." + queue.getName())))) {
                    queue.setAppid(value);
                    queueAppid = value;
                }
                if (queueAppid != null) {
                    MQInit.initQueue(name, queue, MQInit.isNeedDeploy(queueAppid));
                    continue;
                }
                MQInit.initQueue(name, queue, true);
            }
            catch (Exception t) {
                logStringBuilder.append(t.getMessage()).append(",").append("queue=").append(queue.getName()).append("\n");
            }
        }
        if (logStringBuilder.length() > 0) {
            logger.error("initRegion error,region=" + region + "," + logStringBuilder);
        }
    }

    private static boolean isNeedDeploy(String appid) {
        return ConsumerSupport.isNeedDeploy(appid);
    }

    private static void initQueue(String region, QueueDef queueDef, boolean isCurrentApp) {
        QueueManager.add(region, queueDef, isCurrentApp);
        if (isCurrentApp && queueDef.isSequential()) {
            String appid = queueDef.getAppid();
            if (appid == null) {
                appid = "*";
            }
            Map sequentialQueue2regionMap = sequentialQueueMap.computeIfAbsent(appid, k -> new HashMap(2));
            sequentialQueue2regionMap.put(queueDef.getName(), region);
        }
    }

    private static void initSequentialQueueElect() {
        if (ConfigForInitConsumer.isNotInitConsumer()) {
            return;
        }
        if (!sequentialQueueMap.isEmpty()) {
            sequentialQueueMap.forEach((appid, sequentialQueue2regionMap) -> {
                if (MQInit.isNeedDeploy(appid) && !sequentialQueue2regionMap.isEmpty()) {
                    Elector elector = ElectFactory.getElector((String)("SequentialQueueElect_" + appid + "_" + System.getProperty("mq.debug.queue.tag", "")));
                    elector.registerListener(new ElectorListener((Map)sequentialQueue2regionMap){
                        final /* synthetic */ Map val$sequentialQueue2regionMap;
                        {
                            this.val$sequentialQueue2regionMap = map;
                        }

                        public void notifyLostMaster() {
                            this.val$sequentialQueue2regionMap.forEach((sequentialQueueName, region) -> {
                                Consumer conumer = QueueManager.getLazyInitConsumer(region, sequentialQueueName);
                                conumer.$$stop();
                            });
                        }

                        public void notifyMaster() {
                            this.val$sequentialQueue2regionMap.forEach((sequentialQueueName, region) -> {
                                RabbitConsumer rabbitConsumer;
                                Consumer consumer = QueueManager.getLazyInitConsumer(region, sequentialQueueName);
                                if (consumer instanceof RabbitConsumer && ChannelFactory.isChannelNeedReBuild((rabbitConsumer = (RabbitConsumer)consumer).getChannel())) {
                                    rabbitConsumer.setChannel(ChannelFactory.getChannel(region));
                                }
                                consumer.start();
                            });
                        }
                    });
                    elector.start();
                }
            });
        }
    }

    private static void initConfigQueueDeploy() {
        String config = System.getProperty("mq.consumer.deployAppIds.config");
        if (StringUtils.isNotEmpty((String)config)) {
            try {
                Properties prop = new Properties();
                StringReader reader = new StringReader(config);
                prop.load(reader);
                for (Map.Entry<Object, Object> next : prop.entrySet()) {
                    String values = next.getValue().toString();
                    String key = next.getKey().toString();
                    deployConfig.putIfAbsent(key, values);
                }
            }
            catch (IOException e) {
                logger.error("load config error,config key: mq.consumer.deployAppIds.config", (Throwable)e);
            }
        }
    }
}

