/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.InitialContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.mq.jms.JMSProtocol;
import kd.bos.mq.jms.reconnect.JMSReconnectCallbackImpl;

public abstract class AbstractJMSProtocol
implements JMSProtocol {
    private static final Log logger = LogFactory.getLog(AbstractJMSProtocol.class);
    protected static final String MQ_JMS_CONNECTION_MAX = "mq.jms.connection.max";
    protected static final int DEFAULT_CONNECTION_COUNT = 2;
    public static final AtomicBoolean listened = new AtomicBoolean(false);
    private static ConcurrentHashMap<String, ConnectionFactory> connectionFactories = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, HashSet<Connection>> connectionPools = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AtomicLong> connectionCount = new ConcurrentHashMap();
    private static final Object mutex = new Object();

    @Override
    public Session createSession(JMSInfo jmsInfo, String serverKey, boolean autoAck) {
        try {
            ConnectionFactory connectionFactory = connectionFactories.computeIfAbsent(serverKey, key -> this.assembleConnectionFactory(jmsInfo));
            Connection connection = this.createConnection(connectionFactory, serverKey);
            if ("true".equals(jmsInfo.getEnableManualReconnect()) && listened.compareAndSet(false, true)) {
                connection.setExceptionListener((ExceptionListener)JMSReconnectCallbackImpl.getReconnectInstance(serverKey));
            }
            connection.start();
            Session session = connection.createSession(false, autoAck ? 1 : 2);
            return session;
        }
        catch (NoSuchElementException ex) {
            logger.error("jms mq getSession error,serverKey={},maybe session instance exceed limit", (Object)serverKey);
            throw new KDException(BosErrorCode.jmsmqException, "jms mq getSession error", (Throwable)ex);
        }
        catch (Exception e) {
            logger.error("jms mq getSession error,serverkey={}", (Object)e, (Object)serverKey);
            throw new KDException(BosErrorCode.jmsmqException, "jms mq getSession error", (Throwable)e);
        }
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory, String serverKey) throws JMSException {
        return AbstractJMSProtocol.roundRobinAndCreateConnection(serverKey, connectionFactory);
    }

    private ConnectionFactory assembleConnectionFactory(JMSInfo jmsInfo) {
        try {
            ConnectionFactory connectionFactory;
            if (jmsInfo.isConnectionFactoryFromJDNI()) {
                InitialContext initialContext = new InitialContext(jmsInfo.getJndiEnvironments());
                connectionFactory = (ConnectionFactory)initialContext.lookup(jmsInfo.getConnectionFactoryJNDIName());
                initialContext.close();
            } else {
                connectionFactory = this.createConnectionFactory(jmsInfo);
            }
            return connectionFactory;
        }
        catch (Exception e) {
            logger.error("jms server createConnectionFactory error", (Throwable)e);
            throw new KDException(BosErrorCode.mqServerConfiguration, "jms server createConnectionFactory error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection roundRobinAndCreateConnection(String serverKey, ConnectionFactory connectionFactory) throws JMSException {
        HashSet connections = connectionPools.computeIfAbsent(serverKey, key -> new HashSet());
        AtomicLong index = connectionCount.computeIfAbsent(serverKey, key -> new AtomicLong(0L));
        int maxConnectionSize = Integer.getInteger(MQ_JMS_CONNECTION_MAX, 2);
        Connection newConnection = null;
        if (connections.size() < maxConnectionSize) {
            Object object = mutex;
            synchronized (object) {
                if (connections.size() < maxConnectionSize) {
                    newConnection = connectionFactory.createConnection();
                    connections.add(newConnection);
                }
            }
        }
        if (newConnection != null) {
            return newConnection;
        }
        int i = 0;
        int target = (int)index.getAndIncrement() % connections.size();
        for (Connection connection : connections) {
            if (target == i) {
                return connection;
            }
            ++i;
        }
        throw new KDException(BosErrorCode.jmsmqException, new Object[]{"jms mq roundRobinConnection return null"});
    }

    public static HashSet<Connection> getPooledConnections(String serverKey) {
        return connectionPools.get(serverKey);
    }
}

