/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.support.AckedCallBack;
import kd.bos.mq.support.MessageCommonAcker;

public class JMSAcker
implements MessageCommonAcker {
    private boolean autoAck;
    private AckedCallBack ackedCallback;
    private int visitStatus = 0;
    private int ackStatus = 0;
    private Session session;
    private Message message;

    public JMSAcker(Session session, Message message, boolean autoAck) {
        this.session = session;
        this.message = message;
        this.autoAck = autoAck;
    }

    public int getAckStatus() {
        return this.ackStatus;
    }

    public void setAckStatus(int ackStatus) {
        this.ackStatus = ackStatus;
    }

    @Override
    public boolean hasDone() {
        return this.visitStatus > 0;
    }

    @Override
    public void ack(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(1);
        if (!this.autoAck) {
            try {
                this.message.acknowledge();
            }
            catch (JMSException e) {
                throw new KDException(BosErrorCode.jmsmqException, "can't ack the message " + messageId, (Throwable)e);
            }
        }
        if (this.ackedCallback != null) {
            this.ackedCallback.call();
        }
    }

    @Override
    public void deny(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(2);
        if (!this.autoAck) {
            try {
                this.session.recover();
            }
            catch (JMSException e) {
                throw new KDException(BosErrorCode.jmsmqException, "can't recover the message " + messageId, (Throwable)e);
            }
        }
    }

    @Override
    public void discard(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(3);
        if (!this.autoAck) {
            try {
                this.message.acknowledge();
            }
            catch (JMSException e) {
                throw new KDException(BosErrorCode.jmsmqException, "can't discard the message " + messageId, (Throwable)e);
            }
        }
    }

    @Override
    public boolean isDenied() {
        return this.ackStatus == 2;
    }

    @Override
    public void setAckedCallBack(AckedCallBack ackedCallback) {
        this.ackedCallback = ackedCallback;
    }

    @Override
    public boolean isAcked() {
        return this.ackStatus == 1;
    }

    @Override
    public boolean isDiscarded() {
        return this.ackStatus == 3;
    }
}

