/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.Broadcast;
import kd.bos.mq.broadcast.Configure;
import kd.bos.mq.broadcast.MessageReceive;
import kd.bos.mq.jms.JMSMessageUtil;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.util.StringUtils;

public class JMSBroadcast
extends Broadcast {
    private static final String BROADCAST_REGION = "broadcast";
    private static final String BROADCAST_QUEUE = Instance.getClusterName() + System.getProperty("mq.debug.queue.tag", "");
    private static final Log logger = LogFactory.getLog(JMSBroadcast.class);
    public static final String COMMON = "common";
    private static HashMap<String, Topic> topics = new HashMap();

    @Override
    public void registerBroadcastConsumer() {
        try {
            JMSBroadcast.registry(null);
            if (!Instance.isAppSplit()) {
                return;
            }
            String[] appIds = Instance.getAppIds();
            if (appIds == null) {
                return;
            }
            Set<String> supportedAppids = Configure.getSupportBroadcastAppids();
            for (String appId : appIds) {
                if (!supportedAppids.contains(appId)) continue;
                JMSBroadcast.registry(appId);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"can't init JMSMQ broadcast mode"});
        }
    }

    @Override
    public void broadcastMessage(byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        Session session = null;
        try {
            session = JMSSessionFactory.getSession(BROADCAST_REGION, false);
            Topic topic = JMSBroadcast.getTopic(session, null);
            MessageProducer producer = session.createProducer((Destination)topic);
            BytesMessage bytesMessage = session.createBytesMessage();
            bytesMessage.setStringProperty("tag", JMSBroadcast.broadcastQueueNameWithAppId(null));
            bytesMessage.writeBytes(message);
            producer.send((Message)bytesMessage);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"boradcastMessage can't send" + e.getMessage()});
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Override
    public void broadcastMessage(String appid, byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        if (!Configure.getSupportBroadcastAppids().contains(appid)) {
            throw new KDException(BosErrorCode.jmsmqException, new Object[]{"app " + appid + " not support broadcast"});
        }
        if (this.broadcastDisable()) {
            return;
        }
        Session session = null;
        try {
            session = JMSSessionFactory.getSession(BROADCAST_REGION, false);
            Topic topic = JMSBroadcast.getTopic(session, appid);
            MessageProducer producer = session.createProducer((Destination)topic);
            BytesMessage bytesMessage = session.createBytesMessage();
            bytesMessage.setStringProperty("tag", JMSBroadcast.broadcastQueueNameWithAppId(appid));
            bytesMessage.writeBytes(message);
            producer.send((Message)bytesMessage);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"boradcastMessage can't send" + e.getMessage()});
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static void registry(String appId) throws JMSException {
        Session session = JMSSessionFactory.getSession(BROADCAST_REGION, false);
        Topic topic = JMSBroadcast.getTopic(session, appId);
        MessageConsumer consumer = JMSSessionFactory.enableSelector(BROADCAST_REGION) ? session.createConsumer((Destination)topic, JMSSessionFactory.getSelector(JMSBroadcast.broadcastQueueNameWithAppId(appId))) : session.createConsumer((Destination)topic);
        consumer.setMessageListener(message -> {
            try {
                if (message instanceof BytesMessage) {
                    byte[] content = JMSMessageUtil.covertBytes((BytesMessage)message);
                    MessageReceive.instance().onMessage(content);
                }
            }
            catch (Exception e) {
                logger.error("deal broadcast message error", (Throwable)e);
            }
            finally {
                try {
                    message.acknowledge();
                }
                catch (JMSException e) {
                    logger.error("deal broadcast message error", (Throwable)e);
                }
            }
        });
    }

    private static Topic getTopic(Session session, String appId) {
        String broadcastQueueName = JMSBroadcast.broadcastQueueNameWithAppId(appId);
        if (JMSSessionFactory.enableSelector(BROADCAST_REGION)) {
            broadcastQueueName = JMSSessionFactory.getVHostQueueName(BROADCAST_REGION, broadcastQueueName);
        }
        return topics.computeIfAbsent(broadcastQueueName, key -> {
            try {
                return session.createTopic(key);
            }
            catch (JMSException e) {
                throw new KDException(BosErrorCode.jmsmqException, "create topic error", (Throwable)e);
            }
        });
    }

    private static String getBroadcastQueueName() {
        return "broadcast_" + BROADCAST_QUEUE;
    }

    private static String broadcastQueueNameWithAppId(String appId) {
        String name = JMSBroadcast.getBroadcastQueueName();
        return StringUtils.isEmpty((String)appId) ? name : name + "_" + appId;
    }

    public static List<String> getBroadcastQueueAppIdNames() {
        Set<String> supportedAppIds = Configure.getSupportBroadcastAppids();
        ArrayList<String> broadcastAppIdNames = new ArrayList<String>();
        if (supportedAppIds != null && supportedAppIds.size() > 0) {
            supportedAppIds.forEach(appId -> broadcastAppIdNames.add(JMSBroadcast.getBroadcastQueueName() + "_" + appId));
        }
        return broadcastAppIdNames;
    }

    private boolean broadcastDisable() {
        return Boolean.getBoolean("boradcast.disable");
    }
}

