/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.JMSDLQConsumer;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.mq.jms.JMSProducerFactory;
import kd.bos.mq.jms.JMSProtocolFactory;
import kd.bos.mq.jms.JMSQueueDeclare;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.jms.delay.JMSInnerDelayManager;
import kd.bos.mq.support.QueueDeclare;

public class JMSDelayManager {
    private static final Log logger = LogFactory.getLog(JMSDelayManager.class);
    private static final String NO_USE_QUEUE = "DLQ.DELAY.NO.USE";
    public static final String ORIGIN_REGION = "targetRegion";
    public static final String ORIGIN_QUEUE = "targetQueue";
    private static Map<String, AtomicBoolean> shardStartedMap = new HashMap<String, AtomicBoolean>();
    private static Map<String, AtomicBoolean> privateStartedMap = new HashMap<String, AtomicBoolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishDelayMessage(BytesMessage bytesMessage, int seconds, String region, String finalQueueName, String tag) throws JMSException {
        JMSInfo jmsInfo = JMSSessionFactory.getJmsInfoByRegion(region);
        boolean supportDLQ = JMSProtocolFactory.getJMSProtocolImpl(jmsInfo.getType()).supportDLQ();
        if (supportDLQ) {
            Session session = null;
            MessageProducer producer = null;
            try {
                session = JMSSessionFactory.getSession(region, false);
                producer = JMSProducerFactory.getProducer(session, NO_USE_QUEUE);
                bytesMessage.setStringProperty(ORIGIN_REGION, region);
                bytesMessage.setStringProperty(ORIGIN_QUEUE, finalQueueName);
                producer.send((Message)bytesMessage, producer.getDeliveryMode(), producer.getPriority(), (long)(seconds * 1000));
            }
            finally {
                if (producer != null) {
                    producer.close();
                }
                if (session != null) {
                    session.close();
                }
            }
        } else {
            JMSInnerDelayManager.publishDelayMessage(bytesMessage, seconds, region, finalQueueName, tag);
        }
    }

    public static void startDLQConsumer() {
        List<String> appIdList;
        List<String> list = appIdList = Instance.getAppIds() == null ? null : Arrays.asList(Instance.getAppIds());
        if (!Instance.isAppSplit() || appIdList != null && appIdList.contains("bos")) {
            for (String serverKey : JMSDelayManager.uniqueServerKeys()) {
                JMSInfo jmsInfo = JMSSessionFactory.getJMSInfo(serverKey);
                boolean supportDLQ = JMSProtocolFactory.getJMSProtocolImpl(jmsInfo.getType()).supportDLQ();
                boolean enableManualDelay = "true".equals(jmsInfo.getEnableManualDelay());
                if (supportDLQ && !enableManualDelay) {
                    AtomicBoolean shardStarted = shardStartedMap.computeIfAbsent(serverKey, key -> new AtomicBoolean(false));
                    AtomicBoolean privateStarted = privateStartedMap.computeIfAbsent(serverKey, key -> new AtomicBoolean(false));
                    JMSDelayManager.startConsumer(serverKey, JMSProtocolFactory.getJMSProtocolImpl(jmsInfo.getType()).obtainShardDLQName(), shardStarted);
                    JMSDelayManager.startConsumer(serverKey, JMSProtocolFactory.getJMSProtocolImpl(jmsInfo.getType()).obtainPrivateDLQName(NO_USE_QUEUE), privateStarted);
                    continue;
                }
                JMSDelayManager.startInnerDelayConsumer(serverKey);
            }
        }
    }

    private static void startConsumer(String serverKey, String deadLetterQueueName, AtomicBoolean started) {
        try {
            if (started.compareAndSet(false, true)) {
                Session session = JMSSessionFactory.getSessionByServerKey(serverKey, false);
                JMSQueueDeclare queueDeclarer = (JMSQueueDeclare)QueueDeclare.get("jms");
                queueDeclarer.setSession(session);
                Queue destination = queueDeclarer.getDestination(deadLetterQueueName);
                MessageConsumer consumer = session.createConsumer((Destination)destination);
                consumer.setMessageListener((MessageListener)new JMSDLQConsumer(session));
            }
        }
        catch (Exception e) {
            logger.warn("JMS startConsumer {} fail,serverKey={}", new Object[]{deadLetterQueueName, serverKey, e});
            started.compareAndSet(true, false);
        }
    }

    private static void startInnerDelayConsumer(String serverKey) {
        try {
            JMSInnerDelayManager.start(serverKey);
        }
        catch (Exception e) {
            logger.warn("JMS startInnerDelayConsumer fail,serverKey={}", (Object)serverKey, (Object)e);
        }
    }

    private static Collection<String> uniqueServerKeys() {
        HashMap<String, String> effectiveServerKey = new HashMap<String, String>();
        for (String key : System.getProperties().stringPropertyNames()) {
            if (key == null || !key.equals("mq.server") && !key.startsWith("mq.server.")) continue;
            JMSInfo jmsInfo = JMSSessionFactory.getJMSInfo(key);
            effectiveServerKey.put(jmsInfo.getType() + jmsInfo.getBrokerUrl(), key);
        }
        return effectiveServerKey.values();
    }
}

