/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Session;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.mq.jms.JMSProtocolFactory;
import kd.bos.util.StringUtils;

public class JMSSessionFactory {
    private static final Log logger = LogFactory.getLog(JMSSessionFactory.class);
    public static final String SPLIT = "_";
    private static ConcurrentHashMap<String, JMSInfo> jmsInfoMap = new ConcurrentHashMap();

    public static Session getSession(String region, boolean autoAck) {
        String serverKey = JMSSessionFactory.getRegionServerKey(region);
        return JMSSessionFactory.createSession(serverKey, autoAck);
    }

    public static Session getSessionByServerKey(String serverKey, boolean autoAck) {
        return JMSSessionFactory.createSession(serverKey, autoAck);
    }

    private static Session createSession(String serverKey, boolean autoAck) {
        JMSInfo jmsInfo = JMSSessionFactory.getJMSInfo(serverKey);
        return JMSProtocolFactory.getJMSProtocolImpl(jmsInfo.getType()).createSession(jmsInfo, serverKey, autoAck);
    }

    public static String getVHostQueueName(String region, String queueRealName) {
        String serverKey = JMSSessionFactory.getRegionServerKey(region);
        JMSInfo jmsInfo = JMSSessionFactory.getJMSInfo(serverKey);
        String vHost = jmsInfo.getVhost();
        if ("true".equals(jmsInfo.getEnableSelector())) {
            return vHost + SPLIT + region;
        }
        return vHost + SPLIT + queueRealName;
    }

    public static String getVhostQueueNameByServerKey(String serverKey, String queueRealName) {
        JMSInfo jmsInfo = JMSSessionFactory.getJMSInfo(serverKey);
        String vHost = jmsInfo.getVhost();
        return vHost + SPLIT + queueRealName;
    }

    public static String getRegionServerKey(String region) {
        String serverKey = "mq.server." + region;
        String server = System.getProperty(serverKey);
        if (StringUtils.isNotEmpty((String)server)) {
            return serverKey;
        }
        return "mq.server";
    }

    public static JMSInfo getJmsInfoByRegion(String region) {
        String serverKey = JMSSessionFactory.getRegionServerKey(region);
        return JMSSessionFactory.getJMSInfo(serverKey);
    }

    public static JMSInfo getJMSInfo(String serverKey) {
        return jmsInfoMap.computeIfAbsent(serverKey, JMSSessionFactory::createJMSInfo);
    }

    public static boolean enableSelector(String region) {
        JMSInfo jmsInfo = JMSSessionFactory.getJmsInfoByRegion(region);
        return "true".equals(jmsInfo.getEnableSelector());
    }

    public static boolean enableSelectorByServerKey(String serverKey) {
        JMSInfo jmsInfo = JMSSessionFactory.getJMSInfo(serverKey);
        return "true".equals(jmsInfo.getEnableSelector());
    }

    public static String getSelector(String queueName) {
        return "tag = '" + queueName + "'";
    }

    private static JMSInfo createJMSInfo(String serverKey) {
        String serverInfo = System.getProperty(serverKey);
        if (serverInfo == null) {
            logger.error("jms server not config for " + serverKey);
            throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"JMS server not config for " + serverKey});
        }
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
            JMSInfo jmsInfo = new JMSInfo();
            String str = Objects.requireNonNull(prop.getProperty("type"), "type can't be empty.");
            jmsInfo.setType(str);
            str = Objects.requireNonNull(prop.getProperty("brokerUrl"), "JMS MQ brokerUrl can't be empty.");
            jmsInfo.setBrokerUrl(str);
            str = prop.getProperty("user", "admin");
            jmsInfo.setUsername(str);
            str = prop.getProperty("password");
            str = StringUtils.isNotEmpty((String)str) ? Encrypters.decode((String)str) : "admin";
            jmsInfo.setPassword(str);
            str = Objects.requireNonNull(prop.getProperty("vhost"), "JMS MQ vhost can't be empty.");
            jmsInfo.setVhost(str);
            str = prop.getProperty("adminPort", "3100");
            jmsInfo.setAdminPort(Integer.parseInt(str));
            str = prop.getProperty("enableManualReconnect");
            jmsInfo.setEnableManualReconnect(str);
            str = prop.getProperty("enableSelector");
            jmsInfo.setEnableSelector(str);
            str = prop.getProperty("enableManualDelay");
            jmsInfo.setEnableManualDelay(str);
            str = prop.getProperty("qcuName");
            jmsInfo.setQcuName(str);
            JMSProtocolFactory.getJMSProtocolImpl(jmsInfo.getType()).setBrokerUrlAndOptimize(jmsInfo, jmsInfo.getBrokerUrl());
            logger.info("serverKey:{},effective brokerUrl:{}", (Object)serverKey, (Object)jmsInfo.getBrokerUrl());
            str = prop.getProperty("jndiProviderUrl");
            if (StringUtils.isNotEmpty((String)str)) {
                jmsInfo.setJndiProviderUrl(str);
                jmsInfo.setConnectionFactoryFromJDNI(true);
                str = Objects.requireNonNull(prop.getProperty("connectionFactoryJNDIName"), "JMS MQ connectionFactoryJNDIName can't be empty when use jndi.");
                jmsInfo.setConnectionFactoryJNDIName(str);
                str = Objects.requireNonNull(prop.getProperty("jndiInitialContextFactory"), "JMS MQ jndiInitialContextFactory can't be empty when use jndi.");
                jmsInfo.setJndiInitialContextFactory(str);
                str = prop.getProperty("jndiUrlPkgPrefixes");
                jmsInfo.setJndiUrlPkgPrefixes(str);
            }
            return jmsInfo;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqConfiguration, new Object[]{e.getMessage()});
        }
    }
}

