/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms.bes;

import com.bes.mq.admin.facade.api.BrokerInfo;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXBasedAdminFacadeFactory;
import com.bes.mq.admin.facade.impl.jeemx.JMXAdminFacadeFactory;
import com.bes.mq.broker.jmx.ConnectionViewMBean;
import com.bes.mq.broker.jmx.QueueViewMBean;
import com.bes.mq.broker.jmx.SubscriptionViewMBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.mq.jms.JMSAdmin;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.mq.support.monitor.vo.ConnectionInfo;
import kd.bos.mq.support.monitor.vo.ConsumerInfo;
import kd.bos.mq.support.monitor.vo.QueueInfo;
import kd.bos.mq.support.monitor.vo.QueuePanel;
import kd.bos.util.StringUtils;

public class BESJMSAdmin
implements JMSAdmin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(JMSInfo jmsInfo, String realQueueName) throws Exception {
        String[] hosts;
        for (String host : hosts = jmsInfo.getHosts().split(",")) {
            JMXAdminFacadeFactory adminFacadeFactory = null;
            try {
                BrokerInfo brokerInfo = new BrokerInfo();
                brokerInfo.setHost(host);
                brokerInfo.setPort(jmsInfo.getAdminPort());
                brokerInfo.setUsername(jmsInfo.getUsername());
                brokerInfo.setPassword(jmsInfo.getPassword());
                adminFacadeFactory = JEEMXBasedAdminFacadeFactory.newFactory((BrokerInfo)brokerInfo);
                adminFacadeFactory.getDestinationsFacade().deleteQueue(realQueueName);
            }
            finally {
                if (adminFacadeFactory != null) {
                    adminFacadeFactory.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getConsumerCountSize(JMSInfo jmsInfo, String realQueueName) throws Exception {
        JMXAdminFacadeFactory adminFacadeFactory = null;
        try {
            BrokerInfo brokerInfo = new BrokerInfo();
            brokerInfo.setHost(jmsInfo.getHosts().split(",")[0]);
            brokerInfo.setPort(jmsInfo.getAdminPort());
            brokerInfo.setUsername(jmsInfo.getUsername());
            brokerInfo.setPassword(jmsInfo.getPassword());
            adminFacadeFactory = JEEMXBasedAdminFacadeFactory.newFactory((BrokerInfo)brokerInfo);
            long l = adminFacadeFactory.getMonitorFacade().getQueue(realQueueName).getConsumerCount();
            return l;
        }
        finally {
            if (adminFacadeFactory != null) {
                adminFacadeFactory.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getQueueMessageSize(JMSInfo jmsInfo, String realQueueName) throws Exception {
        JMXAdminFacadeFactory adminFacadeFactory = null;
        try {
            BrokerInfo brokerInfo = new BrokerInfo();
            brokerInfo.setHost(jmsInfo.getHosts().split(",")[0]);
            brokerInfo.setPort(jmsInfo.getAdminPort());
            brokerInfo.setUsername(jmsInfo.getUsername());
            brokerInfo.setPassword(jmsInfo.getPassword());
            adminFacadeFactory = JEEMXBasedAdminFacadeFactory.newFactory((BrokerInfo)brokerInfo);
            long l = adminFacadeFactory.getMonitorFacade().getQueue(realQueueName).getQueueSize();
            return l;
        }
        finally {
            if (adminFacadeFactory != null) {
                adminFacadeFactory.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueuePanel getQueueInfo(JMSInfo jmsInfo, String filterQueueName) throws Exception {
        JMXAdminFacadeFactory adminFacadeFactory = null;
        try {
            BrokerInfo brokerInfo = new BrokerInfo();
            brokerInfo.setHost(jmsInfo.getHosts().split(",")[0]);
            brokerInfo.setPort(jmsInfo.getAdminPort());
            brokerInfo.setUsername(jmsInfo.getUsername());
            brokerInfo.setPassword(jmsInfo.getPassword());
            adminFacadeFactory = JEEMXBasedAdminFacadeFactory.newFactory((BrokerInfo)brokerInfo);
            Collection connections = adminFacadeFactory.getMonitorFacade().getConnections();
            HashMap<String, ConnectionInfo> connectionInfoMap = new HashMap<String, ConnectionInfo>(8);
            for (ConnectionViewMBean connectionViewMBean : connections) {
                String address = connectionViewMBean.getRemoteAddress();
                String connectionId = connectionViewMBean.getConnectionId();
                ConnectionInfo connectionInfo = new ConnectionInfo();
                connectionInfo.setRemoteAdress(address);
                connectionInfo.setBrokerAdress(brokerInfo.getHost() + ":" + jmsInfo.getPort());
                connectionInfo.setConnectionId(connectionId);
                connectionInfoMap.put(connectionId, connectionInfo);
            }
            Collection queueViewMBeans = adminFacadeFactory.getMonitorFacade().getQueues();
            QueuePanel panel = new QueuePanel();
            ArrayList<QueueInfo> queueList = new ArrayList<QueueInfo>(64);
            int totalQueueSize = 0;
            for (QueueViewMBean queueViewMBean : queueViewMBeans) {
                String queueName = queueViewMBean.getName();
                if (!this.isOpenQueue(queueName, jmsInfo.getVhost())) continue;
                ++totalQueueSize;
                if (StringUtils.isNotEmpty((String)filterQueueName) && !queueName.contains(filterQueueName)) continue;
                long queueSize = queueViewMBean.getQueueSize();
                long flightCount = queueViewMBean.getInFlightCount();
                QueueInfo queue = new QueueInfo();
                queue.setName(queueName.startsWith(jmsInfo.getVhost()) ? queueName.substring(jmsInfo.getVhost().length() + 1) : queueName);
                queue.setTotal(queueSize);
                queue.setUnacknowledged(flightCount);
                queue.setReady(queueSize - flightCount);
                queue.setState("running");
                queue.setVhost(jmsInfo.getVhost());
                ArrayList<ConsumerInfo> consumerInfos = new ArrayList<ConsumerInfo>(4);
                Collection consumers = adminFacadeFactory.getMonitorFacade().getQueueConsumers(queueName);
                for (SubscriptionViewMBean cons : consumers) {
                    ConsumerInfo consumerInfo = new ConsumerInfo();
                    consumerInfo.setPrefetchsize(cons.getPrefetchSize());
                    consumerInfo.setConsumerTag(cons.getClientId() + ":" + cons.getSessionId());
                    consumerInfo.setConnectionInfo((ConnectionInfo)connectionInfoMap.get(cons.getClientId()));
                    consumerInfos.add(consumerInfo);
                }
                queue.setConsumers(consumerInfos);
                queueList.add(queue);
            }
            panel.setFilteredCount(queueList.size());
            panel.setQueueInfos(queueList);
            panel.setTotalCount(totalQueueSize);
            QueuePanel queuePanel = panel;
            return queuePanel;
        }
        finally {
            if (adminFacadeFactory != null) {
                adminFacadeFactory.clear();
            }
        }
    }

    private boolean isOpenQueue(String queueName, String vhost) {
        String commonQueuePrefix = "BESMQ";
        String broadcastPrefix = "broadcast";
        String dlqPrefix = "DLQ";
        return queueName.startsWith(vhost) || queueName.startsWith(commonQueuePrefix) || queueName.startsWith(broadcastPrefix) || queueName.startsWith(dlqPrefix);
    }
}

