/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms.bes;

import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.BESMQPrefetchPolicy;
import com.bes.mq.RedeliveryPolicy;
import com.bes.mq.pool.PooledConnectionFactory;
import com.bes.mq.util.URISupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.AbstractJMSProtocol;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.util.StringUtils;

public class BESJMSProtocol
extends AbstractJMSProtocol {
    private static final Log logger = LogFactory.getLog(BESJMSProtocol.class);
    private static final String MQ_BES_BROKER_URL_OPTIMIZE = "mq.bes.brokerUrl.optimize";
    private static final String MAX_INACTIVITY_DURATION = "protocolFormat.maxInactivityDuration";
    private static final String MQ_BES_SEND_TIMEOUT = "mq.bes.send.timeout";
    private static final String MQ_BES_QUEUE_PREFETCH = "mq.bes.queue.prefetch";
    private static final String MQ_BES_TOPIC_PREFETCH = "mq.bes.topic.prefetch";
    private static final String MQ_BES_SESSION_MAX = "mq.bes.perConnection.maxSession";
    private static final String MQ_BES_BLOCK_CLIENT = "mq.bes.blockClient";
    private static final String MQ_BES_REDELIVER_MAX_TIMES = "mq.bes.redeliver.maxTimes";
    private static final String MQ_BES_REDELIVER_INITIAL_DELAY = "mq.bes.redeliver.initialDelay";
    private static final String MQ_BES_REDELIVER_ACK_OFF_MULTIPLIER = "mq.bes.redeliver.ackOffMultiplier";
    private static final String MQ_BES_CONNECTION_MAX_THREAD_POOL_SIZE = "mq.bes.connection.maxThreadPoolSize";
    private static final String SHARD_DEAD_LETTER_QUEUE = "BESMQ.DLQ.QUEUE";
    private static final String PRI_DEAD_LETTER_QUEUE = "BESMQ.DLQ.QUEUE.";

    @Override
    public void setBrokerUrlAndOptimize(JMSInfo jmsInfo, String brokerUrl) throws URISyntaxException {
        URI oldBrokerURI = new URI(brokerUrl);
        URI newBrokerURI = new URI(brokerUrl);
        StringBuilder hosts = new StringBuilder();
        int port = 0;
        HashMap<String, String> optimizeParam = new HashMap<String, String>();
        optimizeParam.put(MAX_INACTIVITY_DURATION, "0");
        if (oldBrokerURI.getScheme().equals("failover")) {
            boolean needReplace = false;
            URISupport.CompositeData compositeData = URISupport.parseComposite((URI)oldBrokerURI);
            for (int i = 0; i < compositeData.getComponents().length; ++i) {
                URI component = compositeData.getComponents()[i];
                if (!StringUtils.isNotEmpty((String)component.getHost()) || component.getPort() <= 0) continue;
                needReplace = true;
                if (i != 0) {
                    hosts.append(",");
                }
                hosts.append(component.getHost());
                port = component.getPort();
                if (component.toString().contains(MAX_INACTIVITY_DURATION)) continue;
                compositeData.getComponents()[i] = URISupport.applyParameters((URI)component, optimizeParam);
            }
            newBrokerURI = needReplace ? compositeData.toURI() : newBrokerURI;
        } else if (StringUtils.isNotEmpty((String)oldBrokerURI.getHost()) && oldBrokerURI.getPort() > 0) {
            hosts.append(oldBrokerURI.getHost());
            port = oldBrokerURI.getPort();
            if (!oldBrokerURI.toString().contains(MAX_INACTIVITY_DURATION)) {
                newBrokerURI = URISupport.applyParameters((URI)oldBrokerURI, optimizeParam);
            }
            newBrokerURI = new URI("failover://(" + newBrokerURI.toString() + ")");
        }
        if ("true".equals(System.getProperty(MQ_BES_BROKER_URL_OPTIMIZE, "true"))) {
            oldBrokerURI = newBrokerURI;
        }
        jmsInfo.setBrokerUrl(oldBrokerURI.toString());
        jmsInfo.setHosts(hosts.toString());
        jmsInfo.setPort(port);
        if (StringUtils.isEmpty((String)jmsInfo.getEnableManualDelay())) {
            jmsInfo.setEnableManualDelay("false");
        }
        if (StringUtils.isEmpty((String)jmsInfo.getEnableManualReconnect())) {
            jmsInfo.setEnableManualReconnect("false");
        }
        if (StringUtils.isEmpty((String)jmsInfo.getEnableSelector())) {
            jmsInfo.setEnableSelector("false");
        }
    }

    @Override
    public ConnectionFactory createConnectionFactory(JMSInfo jmsInfo) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setConnectionFactory(BESJMSProtocol.createConnectionFactory0(jmsInfo));
        pooledConnectionFactory.setMaxConnections(Integer.getInteger("mq.jms.connection.max", 2).intValue());
        pooledConnectionFactory.setMaxSessionsPerConnection(Integer.getInteger(MQ_BES_SESSION_MAX, 4096).intValue());
        pooledConnectionFactory.setBlockClient(Boolean.parseBoolean(System.getProperty(MQ_BES_BLOCK_CLIENT, "false")));
        return pooledConnectionFactory;
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory, String serverKey) throws JMSException {
        Connection connection = connectionFactory.createConnection();
        return connection;
    }

    @Override
    public boolean supportDLQ() {
        return true;
    }

    @Override
    public String obtainShardDLQName() {
        return SHARD_DEAD_LETTER_QUEUE;
    }

    @Override
    public String obtainPrivateDLQName(String originQueueName) {
        return PRI_DEAD_LETTER_QUEUE + originQueueName;
    }

    private static ConnectionFactory createConnectionFactory0(JMSInfo jmsInfo) {
        try {
            BESMQConnectionFactory besmqConnectionFactory = new BESMQConnectionFactory();
            besmqConnectionFactory.setUserName(jmsInfo.getUsername());
            besmqConnectionFactory.setPassword(jmsInfo.getPassword());
            besmqConnectionFactory.setBrokerURL(jmsInfo.getBrokerUrl());
            besmqConnectionFactory.setSendTimeout(Integer.getInteger(MQ_BES_SEND_TIMEOUT, 120000).intValue());
            besmqConnectionFactory.setSyncSendPersistentMessage(true);
            int allMaxPoolSize = Integer.getInteger(MQ_BES_CONNECTION_MAX_THREAD_POOL_SIZE, 200) / Integer.getInteger("mq.jms.connection.max", 2);
            besmqConnectionFactory.setMaxThreadPoolSize(allMaxPoolSize);
            besmqConnectionFactory.setWatchTopicNotifications(false);
            besmqConnectionFactory.setClientIDPrefix(Instance.getInstanceId());
            BESMQPrefetchPolicy prefetchPolicy = besmqConnectionFactory.getPrefetchPolicy();
            prefetchPolicy.setQueuePrefetch(Integer.getInteger(MQ_BES_QUEUE_PREFETCH, 10).intValue());
            prefetchPolicy.setTopicPrefetch(Integer.getInteger(MQ_BES_TOPIC_PREFETCH, 10).intValue());
            RedeliveryPolicy redeliveryPolicy = besmqConnectionFactory.getRedeliveryPolicy();
            redeliveryPolicy.setMaximumRedeliveries(Integer.getInteger(MQ_BES_REDELIVER_MAX_TIMES, 6).intValue());
            redeliveryPolicy.setInitialRedeliveryDelay((long)Integer.getInteger(MQ_BES_REDELIVER_INITIAL_DELAY, 2000).intValue());
            redeliveryPolicy.setBackOffMultiplier((double)Integer.getInteger(MQ_BES_REDELIVER_ACK_OFF_MULTIPLIER, 1).intValue());
            redeliveryPolicy.setUseExponentialBackOff(true);
            BESMQConnectionFactory connectionFactory = besmqConnectionFactory;
            return connectionFactory;
        }
        catch (Exception e) {
            logger.error("bes server getConnectionFactory error", (Throwable)e);
            throw new KDException(BosErrorCode.besmqConfiguration, "bes server getConnectionFactory error", (Throwable)e);
        }
    }
}

