/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms.reconnect;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.mq.jms.AbstractJMSProtocol;
import kd.bos.mq.jms.delay.JMSInnerDelayManager;
import kd.bos.mq.jms.reconnect.AutoReconnectAdapter;
import kd.bos.mq.jms.reconnect.JMSReconnectCallback;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;

public class JMSReconnectCallbackImpl
implements JMSReconnectCallback {
    private static Log logger = LogFactory.getLog(JMSReconnectCallbackImpl.class);
    private static Map<String, JMSReconnectCallbackImpl> serverKeyConnectionCallback = new HashMap<String, JMSReconnectCallbackImpl>();
    private String serverKey;

    private JMSReconnectCallbackImpl(String serverKey) {
        this.serverKey = serverKey;
    }

    @Override
    public void onConnectionLost() throws JMSException {
        logger.info("reconnect do onConnectionLost start ");
        QueueManager.getConsumers().forEach((key, con) -> {
            Consumer consumer = (Consumer)con;
            consumer.$$stop();
        });
        JMSInnerDelayManager.stop();
        HashSet<Connection> connections = AbstractJMSProtocol.getPooledConnections(this.serverKey);
        if (connections != null && connections.size() != 0) {
            for (Connection connection : connections) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            connections.clear();
        }
        AbstractJMSProtocol.listened.compareAndSet(true, false);
        logger.info("reconnect do onConnectionLost end ");
    }

    @Override
    public void tryReconnecting() throws JMSException {
        logger.info("reconnect do tryReconnecting start ");
        for (Object con : QueueManager.getConsumers().values()) {
            Consumer consumer = (Consumer)con;
            try {
                consumer.start();
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
        JMSInnerDelayManager.restart();
        BroadcastService.start();
        logger.info("reconnect do tryReconnecting end ");
    }

    public static AutoReconnectAdapter getReconnectInstance(String serverKey) {
        JMSReconnectCallbackImpl callback = serverKeyConnectionCallback.computeIfAbsent(serverKey, JMSReconnectCallbackImpl::new);
        return new AutoReconnectAdapter(callback);
    }
}

