/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms.tlq;

import com.tongtech.jms.protocol.io.TlqRemoteMQAddress;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.tmqi.jmsclient.MQAddressList;
import java.net.MalformedURLException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import kd.bos.instance.Instance;
import kd.bos.mq.jms.AbstractJMSProtocol;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.util.StringUtils;

public class TLQJMSProtocol
extends AbstractJMSProtocol {
    private static final int TLQ_ADMIN_PORT = 10252;
    private static final int JMS_DEFAULT_PORT = 3100;
    private static final String TLQ_DEFAULT_QCU_NAME = "qcu1";
    private static final String MQ_TLQ_QUEUE_PREFETCH = "mq.tlq.queue.prefetch";
    private static final String MQ_TLQ_QUEUE_PREFETCH_VAL = "100";
    private static final String TMQI_ADDRESS_LIST = "tmqiAddressList";
    private static final String TMQI_DEFAULT_USERNAME = "tmqiDefaultUsername";
    private static final String TMQI_DEFAULT_PASSWORD_KEY = "tmqiDefaultPassword";
    private static final String TMQI_RECONNECT_ENABLED = "tmqiReconnectEnabled";
    private static final String TMQI_CONFIGURED_CLIENT_ID = "tmqiConfiguredClientID";
    private static final String TMQI_CONSUMER_FLOW_LIMIT = "tmqiConsumerFlowLimit";
    private static final String TMQI_ACK_TIMEOUT = "tmqiAckTimeout";
    private static final String MQ_TLQ_ACK_TIMEOUT = "mq.tlq.ack.timeout";
    private static final String MQ_TLQ_ACK_TIMEOUT_VAL = "1800000";
    private static final String TMQI_CONSUMER_FLOW_THRESHOLD = "tmqiConsumerFlowThreshold";
    private static final String MQ_TLQ_TMQI_CONSUMER_FLOW_THRESHOLD = "mq.tlq.tmqiConsumerFlowThreshold";
    private static final String TMQI_PRODUCER_FLOW_BYTES_LIMIT = "tmqiProducerFlowBytesLimit";
    private static final String MQ_TLQ_TMQI_PRODUCER_FLOW_BYTES_LIMIT = "mq.tlq.tmqiProducerFlowBytesLimit";

    @Override
    public void setBrokerUrlAndOptimize(JMSInfo jmsInfo, String brokerUrl) {
        try {
            StringBuilder hosts = new StringBuilder();
            InjectorUtil.init();
            MQAddressList aList = MQAddressList.createMQAddressList((String)jmsInfo.getBrokerUrl());
            for (int i = 0; i < aList.size(); ++i) {
                TlqRemoteMQAddress address = (TlqRemoteMQAddress)aList.get(0);
                String host = address.getHostName();
                hosts.append(host);
                if (i == aList.size() - 1) continue;
                hosts.append(",");
            }
            if (jmsInfo.getAdminPort() == 3100) {
                jmsInfo.setAdminPort(10252);
            }
            if (StringUtils.isEmpty((String)jmsInfo.getQcuName())) {
                jmsInfo.setQcuName(TLQ_DEFAULT_QCU_NAME);
            }
            jmsInfo.setHosts(hosts.toString());
            if (StringUtils.isEmpty((String)jmsInfo.getEnableManualDelay())) {
                jmsInfo.setEnableManualDelay("true");
            }
            if (StringUtils.isEmpty((String)jmsInfo.getEnableManualReconnect())) {
                jmsInfo.setEnableManualReconnect("true");
            }
            if (StringUtils.isEmpty((String)jmsInfo.getEnableSelector())) {
                jmsInfo.setEnableSelector("true");
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public ConnectionFactory createConnectionFactory(JMSInfo jmsInfo) {
        com.tongtech.tmqi.ConnectionFactory connectionFactory = new com.tongtech.tmqi.ConnectionFactory();
        try {
            connectionFactory.setProperty(TMQI_ADDRESS_LIST, jmsInfo.getBrokerUrl());
            connectionFactory.setProperty(TMQI_DEFAULT_USERNAME, jmsInfo.getUsername());
            connectionFactory.setProperty(TMQI_DEFAULT_PASSWORD_KEY, jmsInfo.getPassword());
            connectionFactory.setProperty(TMQI_RECONNECT_ENABLED, "true");
            connectionFactory.setProperty(TMQI_CONFIGURED_CLIENT_ID, Instance.getInstanceId());
            connectionFactory.setProperty(TMQI_CONSUMER_FLOW_LIMIT, System.getProperty(MQ_TLQ_QUEUE_PREFETCH, MQ_TLQ_QUEUE_PREFETCH_VAL));
            connectionFactory.setProperty(TMQI_CONSUMER_FLOW_THRESHOLD, System.getProperty(MQ_TLQ_TMQI_CONSUMER_FLOW_THRESHOLD, "50"));
            connectionFactory.setProperty(TMQI_ACK_TIMEOUT, System.getProperty(MQ_TLQ_ACK_TIMEOUT, MQ_TLQ_ACK_TIMEOUT_VAL));
            connectionFactory.setProperty(TMQI_PRODUCER_FLOW_BYTES_LIMIT, System.getProperty(MQ_TLQ_TMQI_PRODUCER_FLOW_BYTES_LIMIT, "10000000"));
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        return connectionFactory;
    }

    @Override
    public boolean supportDLQ() {
        return false;
    }

    @Override
    public String obtainShardDLQName() {
        return null;
    }

    @Override
    public String obtainPrivateDLQName(String originQueueName) {
        return null;
    }
}

