/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.kafka.KafkaConfig;
import kd.bos.mq.kafka.KafkaMQTopicUtil;
import kd.bos.mq.kafka.KafkaTopicManager;
import kd.bos.mq.kafka.ProducerFactory;
import kd.bos.mq.support.QueueManager;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ConsumerFactory {
    private static final Log LOGGER = LogFactory.getLog(ConsumerFactory.class);
    private static Map<String, Thread> APPID_POLLTHREAD_MAP = new HashMap<String, Thread>(64);
    private static Map<String, Thread> APPID_COMMITTHREAD_MAP = new HashMap<String, Thread>(64);
    private static Map<String, KafkaConsumer<String, byte[]>> APPID_CONSUMER_MAP = new HashMap<String, KafkaConsumer<String, byte[]>>(64);

    public static KafkaConsumer<String, byte[]> getConsumer(String region, String queueName) {
        try {
            KafkaConsumer consumer;
            String serverKey = ProducerFactory.getRegionServerKey(region);
            KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
            QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueName);
            String appId = def.getAppid();
            if (appId == null) {
                appId = "default";
            }
            if ((consumer = APPID_CONSUMER_MAP.get(appId)) == null) {
                Properties consumerConfig = KafkaConfig.getConsumerConfig(kafkaInfo);
                String groupId = KafkaTopicManager.getGroupId(kafkaInfo.getVhost(), region, queueName);
                consumerConfig.put("group.id", groupId);
                consumer = new KafkaConsumer(consumerConfig);
                APPID_CONSUMER_MAP.put(appId, (KafkaConsumer<String, byte[]>)consumer);
            }
            return consumer;
        }
        catch (KDException e) {
            LOGGER.error("ConsumerFactory getConsumer failed:", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"ConsumerFactory getConsumer failed" + e.getMessage()});
        }
    }

    public static KafkaConsumer<String, byte[]> getBroadcastConsumer(String region, String queueName, String groupId) {
        KafkaConsumer consumer;
        try {
            String serverKey = ProducerFactory.getRegionServerKey(region);
            KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
            String topic = ProducerFactory.getTopicAndGroupName(kafkaInfo.getVhost(), queueName);
            Properties consumerConfig = KafkaConfig.getConsumerConfig(kafkaInfo);
            consumerConfig.put("group.id", groupId);
            consumer = new KafkaConsumer(consumerConfig);
            consumer.subscribe(Collections.singleton(topic));
            int numPartitions = Integer.parseInt(System.getProperty("mq.kafka.topic.partitions", "4"));
            KafkaMQTopicUtil.createTopic(kafkaInfo, topic, numPartitions);
        }
        catch (KDException e) {
            LOGGER.error("ConsumerFactory getBroadcastConsumer failed:", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"ConsumerFactory getBroadcastConsumer failed" + e.getMessage()});
        }
        return consumer;
    }

    public static void putAppIdPollThread(String appId, Thread thread) {
        APPID_POLLTHREAD_MAP.putIfAbsent(appId, thread);
    }

    public static Thread getAppIdPollThread(String appId) {
        return APPID_POLLTHREAD_MAP.get(appId);
    }

    public static void putAppIdSubmitThread(String appId, Thread thread) {
        APPID_COMMITTHREAD_MAP.putIfAbsent(appId, thread);
    }

    public static Thread getAppIdSubmitThread(String appId) {
        return APPID_COMMITTHREAD_MAP.get(appId);
    }
}

