/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.kafka.CommitThread;
import kd.bos.mq.kafka.ConsumerFactory;
import kd.bos.mq.kafka.KafkaTopicManager;
import kd.bos.mq.kafka.PollThread;
import kd.bos.mq.kafka.ProducerFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.ConsumerManager;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class KafkaConsumer
implements Consumer {
    private static final Log LOGGER = LogFactory.getLog(KafkaConsumer.class);
    private String queue;
    private boolean autoAck;
    private int concurrency;
    private MessageConsumer mc;
    private String region;
    private org.apache.kafka.clients.consumer.KafkaConsumer<String, byte[]> consumer;
    private volatile boolean isStartedFlag;
    private Date startAt;
    private String topic;
    private String appId;

    public KafkaConsumer(String region, String queue, boolean autoAck, int concurrency, MessageConsumer mc, int maxQueueLength) {
        this.region = region;
        this.queue = queue;
        this.concurrency = concurrency;
        this.mc = mc;
        this.autoAck = autoAck;
        ConsumerManager.getConsumerounter().inc();
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getQueueName() {
        return this.queue;
    }

    @Override
    public boolean isAutoAck() {
        return this.autoAck;
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        return this.mc;
    }

    @Override
    public Date getStartAt() {
        return this.startAt;
    }

    @Override
    public void start() {
        try {
            this.isStartedFlag = true;
            this.startAt = new Date();
            QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(this.region, this.queue);
            String serverKey = ProducerFactory.getRegionServerKey(this.region);
            KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
            this.topic = KafkaTopicManager.getTopic(kafkaInfo.getVhost(), this.region, this.queue);
            QueueManager.declareIfNeed(null, this.region, this.queue, queueDef.getMaxQueueLength());
            this.consumer = ConsumerFactory.getConsumer(this.region, this.queue);
            String defAppId = queueDef.getAppid();
            this.appId = StringUtils.isEmpty((String)defAppId) ? "default" : defAppId;
            Thread pollThread = ConsumerFactory.getAppIdPollThread(this.appId);
            if (pollThread == null) {
                ReentrantLock reentrantLock = new ReentrantLock();
                String pollThreadName = "kafkaConsumer-poll-" + this.region + "-" + this.appId;
                pollThread = new PollThread(pollThreadName, this.region, this.appId, this.consumer, reentrantLock);
                ConsumerFactory.putAppIdPollThread(this.appId, pollThread);
                pollThread.start();
                LOGGER.info(pollThreadName + " start...");
                String commitThreadName = "kafkaConsumer-commit-" + this.region + "-" + this.appId;
                CommitThread commitThread = new CommitThread(commitThreadName, this.appId, this.consumer, reentrantLock, (PollThread)pollThread);
                ConsumerFactory.putAppIdSubmitThread(this.appId, commitThread);
                commitThread.start();
                LOGGER.info(commitThreadName + " start...");
            }
        }
        catch (Exception e) {
            ExceptionLogger.log("Can't init consumer for queue " + this.queue, e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"Can't init consumer for queue " + this.queue});
        }
    }

    @Override
    public void $$stop() {
        try {
            this.isStartedFlag = false;
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception());
            LOGGER.info("print stack for appId={},region={},queue={},topic={} to debug:{}", new Object[]{this.appId, this.region, this.queue, this.topic, exceptionStackTraceMessage});
            KafkaTopicManager.removeTopic(this.appId, this.topic);
        }
        catch (Exception e) {
            ExceptionLogger.log("error when stop mqchannel" + this.queue, e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStartedFlag;
    }
}

