/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.kafka.KafkaPublisher;
import kd.bos.mq.kafka.ProducerFactory;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionStrategy;
import org.apache.kafka.clients.producer.KafkaProducer;

public class KafkaFactory
extends MQFactory {
    private static final Log LOGGER = LogFactory.getLog(KafkaFactory.class);

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName) {
        if (region == null) {
            throw new KDException(BosErrorCode.kafkaConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queueName});
        }
        String queueRealName = QueueManager.getRealQueueName(region, queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        if (def == null) {
            throw new KDException(BosErrorCode.kafkaConfiguration, new Object[]{"queue not configured for " + region + "/" + queueName});
        }
        return this._createPublisher(region, queueRealName);
    }

    private MessagePublisher _createPublisher(String region, String queueName) {
        String serverKey = ProducerFactory.getRegionServerKey(region);
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
        KafkaProducer<String, byte[]> producer = ProducerFactory.getProducer(region, queueName, kafkaInfo);
        try {
            QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueName);
            QueueManager.declareIfNeed(null, region, queueName, def.getMaxQueueLength());
            if (!"schedule".equals(region)) {
                ConsumerSupport.setAcrossNodeConsume(region, queueName, def);
            }
            return new KafkaPublisher(producer, queueName, region, kafkaInfo.getVhost());
        }
        catch (Exception t) {
            LOGGER.error("KafkaFactory.createSimplePublisher error", (Throwable)t);
            throw new KDException((Throwable)t, BosErrorCode.kafkaException, new Object[]{"error when create publisher,region:" + region + ",queueName:" + queueName});
        }
    }

    @Override
    public MessagePublisher $createPublisherWithRealQueueName(String region, String realQueueName) {
        return this._createPublisher(region, realQueueName);
    }

    @Override
    public MessagePublisher $createPublisherWithAppid(String region, QueueDef def, String appid) {
        String queueRealName = QueueManager.getRealQueueNameWithAppid(region, def.getName(), appid);
        QueueManager._$defineQueue(region, def, appid);
        return this._createPublisher(region, queueRealName);
    }

    @Override
    public MessagePublisher createPartitionPublisher(String region, String queue, PartitionStrategy partitionStrategy) {
        throw new KDException(BosErrorCode.kafkaException, new Object[]{"can't createPartitionPublisher directly!"});
    }
}

