/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.kafka.KafkaInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.kafka.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;

public class KafkaMQTopicUtil {
    private static final Log LOGGER = LogFactory.getLog(KafkaMQTopicUtil.class);
    private static volatile AdminClient ADMIN_CLIENT;
    private static final Object LOCKER;
    private static Semaphore SEMAPHORE_CREATETOPIC;

    private KafkaMQTopicUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createTopic(KafkaInfo kafkaInfo, String topicName, int numPartitions) {
        int tryTimes;
        String createTopicEnbale = System.getProperty("mq.kafka.topic.autocreate.enable", "true");
        boolean createTopicFlag = Boolean.parseBoolean(createTopicEnbale);
        if (!createTopicFlag) {
            return true;
        }
        KafkaMQTopicUtil.initAdminClient(kafkaInfo);
        if (KafkaMQTopicUtil.isTopicExist(topicName)) {
            return true;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        short replicationFactor = 1;
        if (kafkaInfo.getHost().split(",").length > 1) {
            replicationFactor = 2;
        }
        int maxTryTimes = 3;
        for (tryTimes = 0; tryTimes < maxTryTimes; ++tryTimes) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            try {
                SEMAPHORE_CREATETOPIC.acquire();
                CreateTopicsResult result = ADMIN_CLIENT.createTopics(Collections.singleton(new NewTopic(topicName, numPartitions, replicationFactor)));
                Map values = result.values();
                values.forEach((name, future) -> future.whenComplete((action, throwable) -> {
                    if (throwable != null) {
                        LOGGER.error("error when KafkaMQTopicUtil createTopic:{},errorMessage:{}", (Object)topicName, (Object)throwable.getMessage());
                    }
                    atomicBoolean.set(true);
                    countDownLatch.countDown();
                }));
            }
            catch (InterruptedException e) {
                LOGGER.error("semaphore InterruptedException");
            }
            finally {
                SEMAPHORE_CREATETOPIC.release();
            }
            try {
                boolean isAwait = countDownLatch.await(30L, TimeUnit.SECONDS);
                if (isAwait) {
                    LOGGER.info("finish createTopic in 30 seconds");
                } else {
                    LOGGER.info("finish createTopic more than 30 seconds");
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("countDownLatch InterruptedException");
            }
            if (atomicBoolean.get()) break;
        }
        if (tryTimes != 0) {
            LOGGER.info("error when KafkaMQTopicUtil createTopic:" + topicName + ",tryTimes=" + tryTimes);
        }
        return atomicBoolean.get();
    }

    static boolean isTopicExist(String topicName) {
        try {
            ADMIN_CLIENT.describeTopics(Collections.singletonList(topicName)).all().get();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initAdminClient(KafkaInfo kafkaInfo) {
        if (ADMIN_CLIENT == null) {
            Object object = LOCKER;
            synchronized (object) {
                if (ADMIN_CLIENT == null) {
                    Properties properties = KafkaConfig.getAdminConfig(kafkaInfo);
                    ADMIN_CLIENT = AdminClient.create((Properties)properties);
                }
            }
        }
    }

    static {
        LOCKER = new Object();
        String permits = System.getProperty("mq.kafka.admin.create.topic.semaphore.permits", "2");
        SEMAPHORE_CREATETOPIC = new Semaphore(Integer.parseInt(permits));
    }
}

