/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.constant.SceneCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.kafka.ClassCastUtil;
import kd.bos.mq.kafka.KafkaDelayManager;
import kd.bos.mq.kafka.KafkaDispatchProducer;
import kd.bos.mq.kafka.ProducerFactory;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaPublisher
extends PublisherSupport {
    private static Log logger = LogFactory.getLog(KafkaPublisher.class);
    private static final String KAFKA_TRACE_NAME = "KafkaPublisher";
    private KafkaProducer<String, byte[]> producer;
    private String queueName;
    private String region;
    private String vhost;

    public KafkaPublisher(KafkaProducer<String, byte[]> producer, String queueName, String region, String vhost) {
        super(false);
        this.producer = producer;
        this.queueName = queueName;
        this.region = region;
        this.vhost = vhost;
    }

    @Override
    protected void _beginTrans() {
    }

    @Override
    protected void _commitTrans() {
    }

    @Override
    protected void _rollbackTrans() {
    }

    @Override
    public void publish(byte[] message) {
        this.publish0(message);
    }

    @Override
    public void publish(String message) {
        this.publish0(message);
    }

    @Override
    public void publish(Object message) {
        this.publish0(message);
    }

    @Override
    public void publishInDbTranscation(Object message) {
        this.publishInDbTranscation(null, message);
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message) {
        this.publishDelayInDbTranscation(routKey, message, -1);
    }

    private void publishDelayInDbTranscation(String routKey, Object message, int seconds) {
        String writtenRouteKey = TX.getWrittenRouteKey();
        this.publish0(message, null, true, writtenRouteKey == null ? routKey : writtenRouteKey, seconds);
    }

    @Override
    public void publishDelayInDbTranscation(Object message, int seconds) {
        this.publishDelayInDbTranscation(null, message, seconds);
    }

    @Override
    public void publishDelay(Object message, int seconds) {
        this.publish0(message, null, false, null, seconds);
    }

    private void publish0(Object message) {
        this.publish0(message, null, false, null);
    }

    private void publish0(Object message, String consumeSynchronizeTag, boolean indbtrans, String routeKey) {
        this.publish0(message, consumeSynchronizeTag, indbtrans, routeKey, -1);
    }

    private void publish0(Object body, String consumeSynchronizeTag, boolean indbtrans, String routeKey, int seconds) {
        Limiter.checkAndRecord((String)SceneCode.MQ.getCode());
        if (!PublisherSupport.isCanPublishMessage(this.queueName)) {
            throw new KDException(BosErrorCode.kafkaException, new Object[]{"The current node has been discarded due to grayscale completion,queue name is " + this.queueName});
        }
        try (TraceSpan span = Tracer.create((String)KAFKA_TRACE_NAME, (String)"publish0", (boolean)true);){
            span.addTag("queueName", this.queueName);
            KafkaProducer<String, byte[]> tempProducer = this.producer;
            TopologyTagInject.setCompentTag((InnerSpan)span.getInnerSpan(), (String)ProducerFactory.getBootstrap(tempProducer), (String)"Kafka", (String)"mq");
            this.queueName = PublisherSupport.getStandardQueue(this.queueName);
            String publishQueueName = ConsumerSupport.getAcrossNodePublishQueueNameGray(this.queueName);
            String topic = this.getTopicName(publishQueueName);
            Message message = this.toMessage(body);
            message.setConsumeSynchronizeTag(consumeSynchronizeTag);
            if (indbtrans) {
                if (routeKey == null) {
                    throw new KDException(BosErrorCode.sQLConnection, new Object[]{"routKey can not be null"});
                }
                if (KdtxSupport.isDtxEnable()) {
                    this.startDTXAndRegistry(message, routeKey, this.region, topic);
                    return;
                }
                this.recordMqTrans(routeKey, message);
                message.setRetryTimes(-1);
            }
            DelayControlManager.installDelayInfo(message, seconds);
            byte[] bytes = MessageSerde.get().encode(message);
            this.checkPayload(bytes, topic);
            if (message.getStartDeliverTime() > 0L) {
                MetaTime metaTime = DelayControlManager.selectMaxMetaTime(seconds);
                String delayTopicName = KafkaDelayManager.getDelayTopicName(metaTime.getName());
                ProducerRecord record = new ProducerRecord(delayTopicName, (Object)bytes);
                record.headers().add("targetTopic", topic.getBytes());
                record.headers().add("startDeliverTime", ClassCastUtil.longToBytes(message.getStartDeliverTime()));
                KafkaDispatchProducer.send((ProducerRecord<String, byte[]>)record).get();
            } else {
                ProducerRecord record = new ProducerRecord(topic, (Object)bytes);
                this.producer.send(record).get();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"can't send,the reason is " + e.getMessage()});
        }
    }

    @Override
    public void $$publishConfirm(byte[] message) {
        try {
            ProducerRecord record = new ProducerRecord(this.queueName, (Object)message);
            this.producer.send(record).get();
        }
        catch (Exception e) {
            logger.error("$$publishConfirm error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"can't publish"});
        }
    }

    private String getTopicName(String publishQueueName) {
        String serverKey = ProducerFactory.getRegionServerKey(this.region);
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
        return ProducerFactory.getTopicAndGroupName(kafkaInfo.getVhost(), publishQueueName);
    }

    private Message toMessage(Object body) {
        Message message = new Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(RandomUtils.nextLong());
        return message;
    }

    @Override
    public void publish(Object message, String partitionKey) {
        throw new KDException(BosErrorCode.kafkaException, new Object[]{"SimplePublisher can't publish message with partitionKey directly!"});
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message, String partitionKey) {
        throw new KDException(BosErrorCode.kafkaException, new Object[]{"SimplePublisher can't publishInDbTranscation with partitionKey directly !"});
    }

    @Override
    public void publishDelay(Object message, int seconds, String partitionKey) {
        throw new KDException(BosErrorCode.kafkaException, new Object[]{"SimplePublisher can't publishDelay message with partitionKey directly!"});
    }

    @Override
    public void close() {
    }
}

