/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.kafka.ProducerFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.StringUtils;

public class KafkaTopicManager {
    private static final Log LOGGER = LogFactory.getLog(KafkaTopicManager.class);
    private static Map<String, String> QUEUENAME_TOPIC_MAP = new ConcurrentHashMap<String, String>(64);
    private static Map<String, String> TOPIC_REGION_MAP = new ConcurrentHashMap<String, String>(64);
    private static Map<String, String> TOPIC_QUEUENAME_MAP = new ConcurrentHashMap<String, String>(64);
    private static Map<String, CopyOnWriteArraySet<String>> APPID_TOPICS_MAP = new ConcurrentHashMap<String, CopyOnWriteArraySet<String>>(64);
    private static Map<String, QueueDef> TOPIC_QUEUEDEF_MAP = new ConcurrentHashMap<String, QueueDef>(64);

    static String getTopic(String vhost, String region, String queueName) {
        String topic;
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(region, queueName);
        String appId = queueDef.getAppid();
        if (StringUtils.isEmpty((String)appId)) {
            appId = "default";
        }
        if (StringUtils.isEmpty((String)(topic = QUEUENAME_TOPIC_MAP.get(queueName)))) {
            topic = ProducerFactory.getTopicAndGroupName(vhost, queueName);
            QUEUENAME_TOPIC_MAP.put(queueName, topic);
            TOPIC_REGION_MAP.put(topic, region);
            TOPIC_QUEUENAME_MAP.put(topic, queueName);
            TOPIC_QUEUEDEF_MAP.put(topic, queueDef);
            CopyOnWriteArraySet<String> topicSet = APPID_TOPICS_MAP.get(appId);
            if (topicSet == null) {
                topicSet = new CopyOnWriteArraySet();
                APPID_TOPICS_MAP.put(appId, topicSet);
            }
            topicSet.add(topic);
        }
        return topic;
    }

    static String getTopicByQueue(String queue) {
        return QUEUENAME_TOPIC_MAP.get(queue);
    }

    static String getRegionByTopic(String topic) {
        return TOPIC_REGION_MAP.get(topic);
    }

    static String getQueueByTopic(String topic) {
        return TOPIC_QUEUENAME_MAP.get(topic);
    }

    static QueueDef getQueueDef(String topic) {
        return TOPIC_QUEUEDEF_MAP.get(topic);
    }

    static CopyOnWriteArraySet<String> getTopicSet(String appId) {
        return APPID_TOPICS_MAP.get(appId);
    }

    static boolean removeTopic(String appId, String topic) {
        QUEUENAME_TOPIC_MAP.remove(TOPIC_QUEUENAME_MAP.get(topic));
        CopyOnWriteArraySet<String> topicSet = APPID_TOPICS_MAP.get(appId);
        return topicSet.remove(topic);
    }

    static String getGroupId(String vhost, String region, String queueName) {
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueName);
        String appId = def.getAppid();
        if (StringUtils.isEmpty((String)appId)) {
            appId = "default";
        }
        return vhost + '_' + region + '_' + appId;
    }
}

