/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kafka.KafkaInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.kafka.KafkaConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;

public class ProducerFactory {
    private static final Log LOGGER = LogFactory.getLog(ProducerFactory.class);
    private static final String PRODUCER_TRACE_NAME = "KafkaProducerFactory";
    private static final Map<String, KafkaProducer<String, byte[]>> appProducers = new ConcurrentHashMap<String, KafkaProducer<String, byte[]>>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaProducer<String, byte[]> getProducer(String region, String queueName, KafkaInfo kafkaInfo) {
        KafkaProducer producer;
        block18: {
            producer = appProducers.get(region);
            try (TraceSpan span = Tracer.create((String)PRODUCER_TRACE_NAME, (String)"getProducer", (boolean)true);){
                span.addTag("queueName", queueName);
                span.addTag("host", kafkaInfo.getHost());
                if (null != producer && ProducerFactory.isProduerAvailable(producer)) break block18;
                Map<String, KafkaProducer<String, byte[]>> map = appProducers;
                synchronized (map) {
                    producer = appProducers.get(region);
                    if (null == producer || !ProducerFactory.isProduerAvailable(producer)) {
                        Properties producerConfig = KafkaConfig.getProducerConfig(kafkaInfo);
                        producer = new KafkaProducer(producerConfig);
                        appProducers.put(region, (KafkaProducer<String, byte[]>)producer);
                    }
                }
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"ProducerFactory.getProducer can't get producer" + e.getMessage()});
            }
        }
        return producer;
    }

    private static boolean isProduerAvailable(KafkaProducer<String, byte[]> producer) {
        Method throwIfProducerClosedMethod = null;
        try {
            throwIfProducerClosedMethod = producer.getClass().getDeclaredMethod("throwIfProducerClosed", new Class[0]);
            throwIfProducerClosedMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("please check kafka version:{}", (Object)e.getMessage());
            return false;
        }
        try {
            throwIfProducerClosedMethod.invoke(producer, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getRegionServerKey(String region) {
        String serverKey = "mq.server." + region;
        String server = System.getProperty(serverKey);
        if (server != null) {
            return serverKey;
        }
        return "mq.server";
    }

    public static String getTopicAndGroupName(String vhost, String queueName) {
        return (vhost + '_' + queueName).replace('.', '-');
    }

    public static String getBootstrap(KafkaProducer<String, byte[]> producer) {
        Field kafkaConfigField = null;
        try {
            kafkaConfigField = producer.getClass().getDeclaredField("producerConfig");
            kafkaConfigField.setAccessible(true);
            ProducerConfig producerConfig = (ProducerConfig)kafkaConfigField.get(producer);
            return (String)producerConfig.getList("bootstrap.servers").get(0);
        }
        catch (Exception e) {
            return "";
        }
    }
}

