/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.Broadcast;
import kd.bos.mq.pigeon.PigeonBroadcastConsumer;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.data.PigeonBroadcastMessageDTO;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;

public class PigeonBroadcast
extends Broadcast {
    private static final Log LOGGER = LogFactory.getLog(PigeonBroadcast.class);

    @Override
    public void registerBroadcastConsumer() {
    }

    @Override
    public void broadcastMessage(byte[] message) {
        this._broadcastMessage(null, message);
    }

    @Override
    public void broadcastMessage(String appId, byte[] message) {
        this._broadcastMessage(appId, message);
    }

    private void _broadcastMessage(String appId, byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        this.checkPayload(message);
        PigeonBroadcastThread.putMessage(new PigeonBroadcastMessageDTO(appId, message, System.currentTimeMillis()));
    }

    private void checkPayload(byte[] bytes) {
        int limit = PublisherSupport.MQ_MESSAGE_PAYLOAD_VALUE;
        if (bytes.length > limit) {
            if (Boolean.parseBoolean(System.getProperty("mq.message.overload.throw", "true"))) {
                throw new KDException(BosErrorCode.mqException, new Object[]{String.format("message body overload,limit %s bytes,actual %s bytes", limit, bytes.length)});
            }
            LOGGER.error("publish0 overload", (Throwable)new KDException(BosErrorCode.mqException, new Object[]{String.format("message body overload,limit %s bytes,actual %s bytes", limit, bytes.length)}));
        }
    }

    private boolean broadcastDisable() {
        return Boolean.getBoolean("boradcast.disable");
    }

    private static class PigeonBroadcastThread
    extends Thread {
        private static final Log LOGGER = LogFactory.getLog(PigeonBroadcastThread.class);
        private static final BlockingQueue<PigeonBroadcastMessageDTO> messageQueue = new LinkedBlockingDeque<PigeonBroadcastMessageDTO>(10000);
        private static final AtomicBoolean isBroadcastThreadStarted = new AtomicBoolean(false);

        private PigeonBroadcastThread() {
        }

        static void putMessage(PigeonBroadcastMessageDTO message) {
            try {
                messageQueue.put(message);
                if (isBroadcastThreadStarted.compareAndSet(false, true)) {
                    PigeonBroadcastThread broadcastThread = new PigeonBroadcastThread();
                    broadcastThread.setName("PigeonBroadcastThread");
                    broadcastThread.setDaemon(true);
                    broadcastThread.start();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        PigeonBroadcastMessageDTO firstMessage = null;
                        try {
                            firstMessage = messageQueue.poll(500L, TimeUnit.MILLISECONDS);
                            if (firstMessage == null) continue;
                            long spanTime = System.currentTimeMillis() - firstMessage.getAddTime();
                            if (spanTime < 500L) {
                                Thread.sleep(500L - spanTime);
                            }
                        }
                        catch (InterruptedException spanTime) {
                            // empty catch block
                        }
                        int currBatchSize = Math.min(messageQueue.size(), PigeonConstant.BROADCAST_BATCH_SIZE_VALUE);
                        ArrayList<PigeonBroadcastMessageDTO> messageList = new ArrayList<PigeonBroadcastMessageDTO>(currBatchSize);
                        messageList.add(firstMessage);
                        for (int i = 0; i < currBatchSize - 1; ++i) {
                            PigeonBroadcastMessageDTO tempMessage = (PigeonBroadcastMessageDTO)messageQueue.poll();
                            messageList.add(tempMessage);
                        }
                        this.endpointBatchRpc(messageList);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        private void endpointBatchRpc(List<PigeonBroadcastMessageDTO> messageList) {
            List<ServiceInfo> allServiceInfoList = this.getAllServiceInfoList();
            PigeonRequestContextUtil.createRpcRequestContext();
            if (!Instance.isAppSplit()) {
                for (ServiceInfo tempServiceInfo : allServiceInfoList) {
                    try {
                        EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)PigeonBroadcastConsumer.class.getName(), (String)"handleBatchRpcMessage", (Object[])new Object[]{messageList});
                    }
                    catch (Exception e) {
                        LOGGER.error("rpcBroadcastMessageError", (Throwable)e);
                    }
                }
                return;
            }
            HashMap<String, List> appId2messageMap = new HashMap<String, List>(messageList.size());
            for (PigeonBroadcastMessageDTO tempMessage : messageList) {
                List tempMessageList = appId2messageMap.computeIfAbsent(tempMessage.getAppId(), key -> new ArrayList());
                tempMessageList.add(tempMessage);
            }
            for (Map.Entry tempEntry : appId2messageMap.entrySet()) {
                List<ServiceInfo> targetServiceInfoList;
                String appId = (String)tempEntry.getKey();
                List tempMessageList = (List)tempEntry.getValue();
                if (appId.equals("_ALL")) {
                    targetServiceInfoList = allServiceInfoList;
                } else {
                    targetServiceInfoList = new ArrayList<ServiceInfo>(5);
                    for (ServiceInfo tempServiceInfo : allServiceInfoList) {
                        if (tempServiceInfo.getAppIds() == null || tempServiceInfo.getAppIds().length <= 0 || !Arrays.asList(tempServiceInfo.getAppIds()).contains(appId)) continue;
                        targetServiceInfoList.add(tempServiceInfo);
                    }
                }
                LOGGER.debug("appId:{},targetServiceInfoList:{}", (Object)appId, targetServiceInfoList);
                for (ServiceInfo tempServiceInfo : targetServiceInfoList) {
                    try {
                        EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)PigeonBroadcastConsumer.class.getName(), (String)"handleBatchRpcMessage", (Object[])new Object[]{tempMessageList});
                    }
                    catch (Exception e) {
                        LOGGER.error("rpcBroadcastMessageError", (Throwable)e);
                    }
                }
            }
        }

        private List<ServiceInfo> getAllServiceInfoList() {
            return ServiceInfoFactory.get().getServiceList();
        }
    }
}

