/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.init.MQInit;
import kd.bos.mq.pigeon.PigeonInfo;
import kd.bos.mq.pigeon.PigeonPublisher;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionStrategy;

public class PigeonFactory
extends MQFactory {
    private static final Log LOGGER = LogFactory.getLog(PigeonFactory.class);

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName) {
        String queueRealName = QueueManager.getRealQueueName(region, queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        if (def == null) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"queue not configured for " + region + "/" + queueName});
        }
        return this._createPublisher(region, queueRealName, def);
    }

    @Override
    public MessagePublisher $createPublisherWithAppid(String region, QueueDef def, String appid) {
        MQInit.waitForMQFinishInit(region);
        String queueRealName = QueueManager.getRealQueueNameWithAppid(region, def.getName(), appid);
        QueueManager._$defineQueue(region, def, appid);
        return this._createPublisher(region, queueRealName, def);
    }

    @Override
    public MessagePublisher $createPublisherWithRealQueueName(String region, String realQueueName) {
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, realQueueName);
        return this._createPublisher(region, realQueueName, def);
    }

    private MessagePublisher _createPublisher(String region, String queueRealName, QueueDef def) {
        try {
            QueueDeclare queueDeclarer = QueueDeclare.get("pigeon");
            queueDeclarer.queueDeclare(region, queueRealName, def.isDuration(), null);
            String serverKey = PigeonmqFactory.getRegionServerKey(region);
            PigeonInfo pigeonInfo = PigeonmqFactory.getPigeonInfo(serverKey);
            return new PigeonPublisher(pigeonInfo.getVhost(), region, queueRealName);
        }
        catch (Error | Exception t) {
            LOGGER.error("PigeonFactory.createSimplePublisher error", t);
            throw new KDException(t, BosErrorCode.mqException, new Object[]{"error when create publisher"});
        }
    }

    @Override
    public MessagePublisher createPartitionPublisher(String region, String queue, PartitionStrategy partitionStrategy) {
        throw new KDException(BosErrorCode.mqException, new Object[]{"can't createPartitionPublisher directly!"});
    }
}

