/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.constant.SceneCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.Gauger;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.pigeon.PigeonQueueManager;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.mq.support.QueueManager;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.StoreDbConfigFactory;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.entity.QueueTodoMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.store.db.helper.QueueTodoMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.topology.TopologyTagInject;

public class PigeonPublisher
extends PublisherSupport {
    private static final Log LOGGER = LogFactory.getLog(PigeonPublisher.class);
    private static final AtomicInteger publishMessageSize = new AtomicInteger(0);
    private static final String PIGEON_TRACE_NAME = "PigeonPublisher";
    private String region;
    private String queueName;
    private String vhost;

    public PigeonPublisher(String vhost, String region, String queueName) {
        super(false);
        this.vhost = vhost;
        this.region = region;
        this.queueName = queueName;
    }

    @Override
    protected void _beginTrans() {
    }

    @Override
    protected void _commitTrans() {
    }

    @Override
    protected void _rollbackTrans() {
    }

    @Override
    public void publish(byte[] message) {
        this.publish0(message);
    }

    @Override
    public void publish(String message) {
        this.publish0(message);
    }

    @Override
    public void publish(Object message) {
        this.publish0(message);
    }

    @Override
    public void publishInDbTranscation(Object message) {
        this.publishInDbTranscation(null, message);
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message) {
        this.publishDelayInDbTranscation(routKey, message, -1);
    }

    @Override
    public void publishDelayInDbTranscation(Object message, int seconds) {
        this.publishDelayInDbTranscation(null, message, seconds);
    }

    private void publishDelayInDbTranscation(String routKey, Object message, int seconds) {
        String writtenRouteKey = TX.getWrittenRouteKey();
        this.publish0(message, true, writtenRouteKey == null ? routKey : writtenRouteKey, seconds);
    }

    @Override
    public void publishDelay(Object message, int seconds) {
        this.publish0(message, false, null, seconds);
    }

    private void publish0(Object message) {
        this.publish0(message, false, null, -1);
    }

    private void publish0(Object body, boolean indbtrans, String routeKey, int seconds) {
        Limiter.checkAndRecord((String)SceneCode.MQ.getCode());
        if (!PublisherSupport.isCanPublishMessage(this.queueName)) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"The current node has been discarded due to grayscale completion,queue name is " + this.queueName});
        }
        try (TraceSpan span = Tracer.create((String)PIGEON_TRACE_NAME, (String)"publish0", (boolean)true);){
            span.addTag("queueName", this.queueName);
            TopologyTagInject.setCompentTag((InnerSpan)span.getInnerSpan(), (String)"", (String)"Pigeon", (String)"mq");
            this.queueName = PublisherSupport.getStandardQueue(this.queueName);
            String publishQueueName = ConsumerSupport.getAcrossNodePublishQueueNameGray(this.queueName);
            long messageId = ID.genLongId();
            Message message = this.toMessage(body, messageId);
            if (indbtrans) {
                if (routeKey == null) {
                    throw new KDException(BosErrorCode.sQLConnection, new Object[]{"routKey can not be null"});
                }
                if (KdtxSupport.isDtxEnable()) {
                    this.startDTXAndRegistry(message, routeKey, this.region, publishQueueName);
                    return;
                }
                this.recordMqTrans(routeKey, message);
            }
            DelayControlManager.installDelayInfo(message, seconds);
            byte[] bytes = MessageSerde.get().encode(message);
            this.checkPayload(bytes, publishQueueName);
            Date schDate = new Date();
            if (message.getStartDeliverTime() > 0L) {
                schDate = this.changeDelayToSchTime(seconds);
            }
            try (TXHandle handle = TX.requiresNew((String)"PIGEON_INSERT_MESSAGE");){
                this.dbInsert(publishQueueName, bytes, schDate);
            }
        }
        catch (Exception e) {
            LOGGER.error("publish0 error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"can't publish"});
        }
    }

    private Date changeDelayToSchTime(int seconds) {
        if (seconds == -1) {
            return new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    private void dbInsert(String publishQueueName, byte[] bodyBytes, Date schDate) {
        IStoreDbConfig storeDbConfig = StoreDbConfigFactory.getDbConfigByRegion((String)this.region);
        if (!PigeonQueueManager.getNoRouteQueueNameSet().contains(publishQueueName)) {
            QueueMessageEntity entity = new QueueMessageEntity();
            Date date = new Date();
            entity.setId(ID.genLongId()).setVhost(this.vhost).setQueueName(publishQueueName).setRegion(this.region).setAppId(QueueManager.getQueueDefWithRealQueueName(this.region, publishQueueName).getAppid()).setMsgData(bodyBytes).setStatus(MessageStatus.READY.getDesc()).setCreateTime(date).setSchTime(schDate);
            QueueMessageEntityHelper.insert((IStoreDbConfig)storeDbConfig, (QueueMessageEntity)entity);
        } else {
            QueueTodoMessageEntity entity = new QueueTodoMessageEntity();
            Date date = new Date();
            entity.setId(ID.genLongId()).setVhost(this.vhost).setQueueName(publishQueueName).setRegion(this.region).setAppId(QueueManager.getQueueDefWithRealQueueName(this.region, publishQueueName).getAppid()).setMsgData(bodyBytes).setStatus(MessageStatus.READY.getDesc()).setCreateTime(date).setSchTime(schDate);
            QueueTodoMessageEntityHelper.insert((IStoreDbConfig)storeDbConfig, (QueueTodoMessageEntity)entity);
        }
        publishMessageSize.incrementAndGet();
    }

    @Override
    public void $$publishConfirm(byte[] message) {
        try {
            this.dbInsert(this.queueName, message, new Date());
        }
        catch (Exception e) {
            LOGGER.error("$$publishConfirm error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"can't publish"});
        }
    }

    private Message toMessage(Object body, long messageId) {
        Message message = new Message();
        message.setBody(body);
        message.setMessageTime();
        message.setInnerId(messageId);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        return message;
    }

    @Override
    public void close() {
    }

    @Override
    public void publish(Object message, String partitionKey) {
        throw new KDException(BosErrorCode.mqException, new Object[]{"SimplePublisher can't publish message with partitionKey directly!"});
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message, String partitionKey) {
        throw new KDException(BosErrorCode.mqException, new Object[]{"SimplePublisher can't publishInDbTranscation  with partitionKey directly!"});
    }

    @Override
    public void publishDelay(Object message, int seconds, String partitionKey) {
        throw new KDException(BosErrorCode.mqException, new Object[]{"SimplePublisher can't publishDelay message with appId directly!"});
    }

    static {
        MetricSystem.gauge((String)"kd.metrics.mq.pigeon.publish.message.size", () -> {
            Gauger metricsObj = new Gauger();
            metricsObj.setValueSupplier(() -> publishMessageSize.getAndSet(0));
            return metricsObj;
        });
    }
}

