/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.pigeon.PigeonConsumerManager;
import kd.bos.mq.support.QueueManager;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.data.PigeonNoRouteQueueNameWrapper;
import kd.bos.pigeon.core.data.PigeonSequentialDTO;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.pigeon.core.support.instance.ServiceInfo;

public class PigeonQueueManager {
    private static final Map<String, PigeonNoRouteQueueNameWrapper> queueRealName2noRouteQueueNameWrapperMap = new ConcurrentHashMap<String, PigeonNoRouteQueueNameWrapper>();
    private static Consumer<PigeonNoRouteQueueNameWrapper> mserviceMarkNoRouteQueueNameConsumer;
    private static final Map<String, QueueNameCachedListener> scene2queueNameListenerMap;
    private static final Map<String, Boolean> queueRealName2sequentialMap;
    private static final Map<String, Set<String>> instanceId2queueRealNameSetMap;
    private static final Map<String, Set<ServiceInfo>> queueRealName2serviceInfoSetMap;
    private static final Map<String, Integer> queueRealName2defconcurrencyMap;

    public static void registerQueueNameListener(String scene, QueueNameCachedListener listener) {
        scene2queueNameListenerMap.putIfAbsent(scene, listener);
    }

    public static void removeQueueNameListener(String scene) {
        scene2queueNameListenerMap.remove(scene);
    }

    public static void registerNoRouteQueueNameConsumer(Consumer<PigeonNoRouteQueueNameWrapper> markNoRouteQueueNameConsumer) {
        mserviceMarkNoRouteQueueNameConsumer = markNoRouteQueueNameConsumer;
    }

    public static void markNoRouteQueueName(PigeonNoRouteQueueNameWrapper noRouteQueueNameWrapper) {
        queueRealName2noRouteQueueNameWrapperMap.putIfAbsent(noRouteQueueNameWrapper.getQueueRealName(), noRouteQueueNameWrapper);
    }

    public static void mserviceMarkNoRouteQueueName(PigeonNoRouteQueueNameWrapper noRouteQueueNameWrapper) {
        queueRealName2noRouteQueueNameWrapperMap.putIfAbsent(noRouteQueueNameWrapper.getQueueRealName(), noRouteQueueNameWrapper);
        if (mserviceMarkNoRouteQueueNameConsumer != null) {
            mserviceMarkNoRouteQueueNameConsumer.accept(noRouteQueueNameWrapper);
        }
    }

    public static void unmarkNoRouteQueueName(String queueName) {
        queueRealName2noRouteQueueNameWrapperMap.remove(queueName);
    }

    public static Set<String> getNoRouteQueueNameSet() {
        return queueRealName2noRouteQueueNameWrapperMap.keySet();
    }

    public static Set<PigeonNoRouteQueueNameWrapper> getCopyNoRouteQueueNameWrapperSet() {
        HashSet<PigeonNoRouteQueueNameWrapper> resultSet = new HashSet<PigeonNoRouteQueueNameWrapper>(queueRealName2noRouteQueueNameWrapperMap.size());
        resultSet.addAll(queueRealName2noRouteQueueNameWrapperMap.values());
        return resultSet;
    }

    public static Set<ServiceInfo> getQueueServiceInfoSet(String queueName) {
        return queueRealName2serviceInfoSetMap.get(queueName);
    }

    public static void cacheQueueDefConcurrency(String queueName, Integer defConcurrency) {
        queueRealName2defconcurrencyMap.put(queueName, defConcurrency);
    }

    public static int getQueueDefConcurrency(String queueName) {
        Integer defconcurrencyInteger = queueRealName2defconcurrencyMap.get(queueName);
        if (defconcurrencyInteger == null) {
            return -1;
        }
        return defconcurrencyInteger;
    }

    public static int getQueueSize(String instanceId) {
        if (PigeonConstant.LOCAL_SERVER_STANDALONE) {
            return PigeonConsumerManager.getQueueNameSet().size();
        }
        return instanceId2queueRealNameSetMap.get(instanceId) == null ? 0 : instanceId2queueRealNameSetMap.get(instanceId).size();
    }

    public static void cacheQueueNameSet(ServiceInfo serviceInfo, Set<String> queueNameSet) {
        instanceId2queueRealNameSetMap.put(serviceInfo.getInstanceId(), queueNameSet);
        for (String tempQueueName : queueNameSet) {
            Set serviceInfoSet = queueRealName2serviceInfoSetMap.computeIfAbsent(tempQueueName, k -> {
                RequestContext oldRc = RequestContext.get();
                for (QueueNameCachedListener tempListener : scene2queueNameListenerMap.values()) {
                    tempListener.cacheQueueName(tempQueueName);
                }
                PigeonRequestContextUtil.set((RequestContext)oldRc);
                return new CopyOnWriteArraySet();
            });
            serviceInfoSet.add(serviceInfo);
        }
    }

    public static void removeQueueNameSet(ServiceInfo serviceInfo) {
        instanceId2queueRealNameSetMap.remove(serviceInfo.getInstanceId());
        ArrayList<String> emptyKeyList = new ArrayList<String>();
        for (Map.Entry<String, Set<ServiceInfo>> entry : queueRealName2serviceInfoSetMap.entrySet()) {
            entry.getValue().remove(serviceInfo);
            if (entry.getValue().size() != 0) continue;
            emptyKeyList.add(entry.getKey());
        }
        for (String tempKey : emptyKeyList) {
            queueRealName2serviceInfoSetMap.remove(tempKey);
        }
    }

    public static Set<String> mserviceGetQueueNameSet() {
        return new HashSet<String>(PigeonConsumerManager.getQueueNameSet());
    }

    public static Boolean getQueueSequential(String queueName) {
        QueueDef queueDef;
        Boolean sequentialBoolean = queueRealName2sequentialMap.get(queueName);
        if (sequentialBoolean == null && (queueDef = QueueManager.getQueueDefWithRealQueueName(null, queueName)) != null) {
            sequentialBoolean = queueDef.isSequential();
            PigeonQueueManager.cacheQueueSequential(queueName, sequentialBoolean);
        }
        return sequentialBoolean;
    }

    public static void cacheQueueSequential(String queueName, Boolean sequentialBoolean) {
        queueRealName2sequentialMap.put(queueName, sequentialBoolean);
    }

    public static PigeonSequentialDTO mserviceGetQueueSequential(String queueName) {
        PigeonSequentialDTO pigeonSequentialDTO = new PigeonSequentialDTO();
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(null, queueName);
        if (queueDef != null) {
            pigeonSequentialDTO.setFind(true);
            pigeonSequentialDTO.setQueueRealName(queueName);
            pigeonSequentialDTO.setSequential(Boolean.valueOf(queueDef.isSequential()));
        }
        return pigeonSequentialDTO;
    }

    static {
        scene2queueNameListenerMap = new ConcurrentHashMap<String, QueueNameCachedListener>();
        queueRealName2sequentialMap = new ConcurrentHashMap<String, Boolean>();
        instanceId2queueRealNameSetMap = new ConcurrentHashMap<String, Set<String>>();
        queueRealName2serviceInfoSetMap = new ConcurrentHashMap<String, Set<ServiceInfo>>();
        queueRealName2defconcurrencyMap = new ConcurrentHashMap<String, Integer>();
    }

    public static interface QueueNameCachedListener {
        public void cacheQueueName(String var1);

        public void removeQueueName(String var1);
    }
}

