/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.rabbitmq.RabbitmqFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;
import org.apache.log4j.Logger;

public class ChannelFactory {
    private static Logger logger = Logger.getLogger(ChannelFactory.class);
    private static final String CHANNEL_TRACE_NAME = "ChannelFactory";
    private static AtomicInteger getChannelNullCount = new AtomicInteger(0);
    private static Map<Channel, String> channelStack = new ConcurrentHashMap<Channel, String>(2);
    private static int recoredSize = Integer.getInteger("mq.livingchannel.recoresize", 1500);

    private static void removeClosedChannel() {
        HashSet remove = new HashSet(1);
        channelStack.forEach((k, v) -> {
            if (!k.isOpen()) {
                remove.add(k);
            }
        });
        remove.forEach(k -> channelStack.remove(k));
    }

    private static Map<String, AtomicInteger> getStackMaps() {
        HashMap<String, AtomicInteger> stacksMap = new HashMap<String, AtomicInteger>(16);
        channelStack.forEach((k, v) -> {
            AtomicInteger count = stacksMap.computeIfAbsent((String)v, s -> new AtomicInteger(0));
            count.incrementAndGet();
        });
        return stacksMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Channel getChannel(String region) {
        try (TraceSpan span = Tracer.create((String)CHANNEL_TRACE_NAME, (String)"getChannel", (boolean)true);){
            span.addTag("region", region);
            Connection con = RabbitmqFactory.getConnectionByRegion((String)region);
            Channel ch = con.createChannel();
            if (ch == null) {
                getChannelNullCount.incrementAndGet();
            } else if (ChannelFactory.isChannelLivingMonitor() && channelStack.size() < 3000) {
                channelStack.computeIfAbsent(ch, k -> ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception()));
            }
            Channel channel = ch;
            return channel;
        }
        catch (IOException e) {
            logger.error((Object)"can't create mqChannel", (Throwable)e);
            throw new KDException(BosErrorCode.rabbitmqException, "can't create channel", (Throwable)e);
        }
    }

    public static String getRegionServerKey(String region) {
        String serverKey = "mq.server." + region;
        String server = System.getProperty(serverKey);
        if (server != null) {
            return serverKey;
        }
        return "mq.server";
    }

    public static boolean isChannelNeedReBuild(Channel channel) {
        boolean needRebuild;
        boolean bl = needRebuild = channel == null || !channel.isOpen() || !channel.getConnection().isOpen();
        if (needRebuild && channel != null) {
            try {
                channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return needRebuild;
    }

    public static int getChannnelNullCount() {
        return getChannelNullCount.get();
    }

    public static boolean isChannelLivingMonitor() {
        return "true".equals(System.getProperty("mq.channe.live.monitor", "true"));
    }

    static {
        Timer timer = new Timer("mqchannelmonitor-clean", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!ChannelFactory.isChannelLivingMonitor()) {
                        return;
                    }
                    ChannelFactory.removeClosedChannel();
                    if (channelStack.size() > recoredSize) {
                        Map stacksMap = ChannelFactory.getStackMaps();
                        channelStack.clear();
                        recoredSize = 200;
                        int count = 0;
                        StringBuilder sb = new StringBuilder();
                        for (Map.Entry entry : stacksMap.entrySet()) {
                            sb.append("[count]").append(((AtomicInteger)entry.getValue()).get());
                            sb.append("[stack]").append((String)entry.getKey());
                            if (count++ < 20) continue;
                            logger.error((Object)("mqchannels maybe leaked, detail: " + sb));
                            sb.setLength(0);
                            count = 0;
                        }
                        if (count > 0) {
                            logger.error((Object)("mqchannels maybe leaked, detail: " + sb));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 300000L, 20000L);
    }
}

