/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.Channel;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.ExceptionLogger;

public class PublisherChannels {
    private static ThreadLocal<CloseableChannels> local = new ThreadLocal<CloseableChannels>(){

        @Override
        protected CloseableChannels initialValue() {
            return new CloseableChannels();
        }
    };

    public static Channel getChannel(String region) {
        CloseableChannels channelContainter = local.get();
        Channel channel = channelContainter.get(region);
        if (ChannelFactory.isChannelNeedReBuild(channel)) {
            Channel c = null;
            for (int i = 0; i < 2; ++i) {
                c = ChannelFactory.getChannel(region);
                if (c != null) {
                    channelContainter.put(region, c);
                    break;
                }
                LockSupport.parkNanos(300000000L);
            }
            if (c == null) {
                ExceptionLogger.log("get mqchannel  is null");
                throw new KDException(BosErrorCode.mqException, new Object[]{"get mqchannel  is null"});
            }
        }
        return channelContainter.get(region);
    }

    private static class CloseableChannels
    implements Closeable {
        private Map<String, Channel> channels = new HashMap<String, Channel>(2);

        private CloseableChannels() {
        }

        @Override
        public void close() throws IOException {
            this.channels.forEach((k, v) -> {
                try {
                    if (v.isOpen()) {
                        v.close();
                    }
                }
                catch (Exception e) {
                    ExceptionLogger.log("mqchannel close error", e);
                }
            });
        }

        public void put(String key, Channel c) {
            this.channels.put(key, c);
        }

        public Channel get(String key) {
            return this.channels.get(key);
        }

        public boolean containsKey(String key) {
            return this.channels.containsKey(key);
        }
    }
}

